package kz.arta.synergy.api.asforms;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormWrapper;
import kz.arta.synergy.api.asforms.pojo.ComponentTypes;
import kz.arta.synergy.pojo.TableCmp;
import kz.arta.synergy.pojo.TestForm;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
public class AsFormServiceTest {

    String expectedTextInputValue = "value_1";
    String expectedNumericInputValue = "value_2";
    String expectedNumericInputKey = "key_1";

    String expectedFileValue = "file_value";
    String expectedFileKey = "file_key";

    String expectedDoubleValue = "45.2";
    String expectedIntegerValue = "456";

    String expectedTableInputValueB1 = "table_input_b1";
    String expectedTableInputValueB2 = "table_input_b2";

    TestForm testForm;
    AsFormService asFormService;

    @BeforeClass
    public void createAsfWrapper() throws IOException {
        AsFormWrapper asFormWrapper = new AsFormWrapper();
        asFormWrapper.addData(AsFormData.textbox("text_input", expectedTextInputValue));
        asFormWrapper.addData(AsFormData.textbox("double_input", expectedDoubleValue));
        asFormWrapper.addData(AsFormData.textbox("integer_input", expectedIntegerValue));
        asFormWrapper.addData(AsFormData.numericinput("numeric_input_key", expectedNumericInputValue, expectedNumericInputKey));
        asFormWrapper.addData(AsFormData.numericinput("numeric_input_value", expectedNumericInputValue, expectedNumericInputKey));
        asFormWrapper.addData(AsFormData.numericinput("file", expectedFileValue, expectedFileKey));

        AsFormData tableData = new AsFormData();
        tableData.setType(ComponentTypes.TABLE);
        tableData.setId("table_cmp");
        tableData.addData(AsFormData.textbox("table_input-b1", expectedTableInputValueB1));
        tableData.addData(AsFormData.numericinput("table_input_2-b1", expectedTableInputValueB1, expectedTableInputValueB1));
        tableData.addData(AsFormData.textbox("table_input-b2", expectedTableInputValueB2));
        tableData.addData(AsFormData.numericinput("table_input_2-b2", expectedTableInputValueB2, expectedTableInputValueB2));
        asFormWrapper.getData().add(tableData);

        RestHttpQuery restHttpQueryMock = Mockito.mock(RestHttpQuery.class);
        Mockito.when(restHttpQueryMock.doQuery(Mockito.any(Query.class))).thenReturn(JsonUtils.toJson(asFormWrapper));
        asFormService = AsFormService.newInstance(new QueryContext("localhost")).setRestHttpQuery(restHttpQueryMock);
        testForm = asFormService.getData(TestForm.class, "123456");
    }

    @Test
    public void testTextInputValue() {
        Assert.assertEquals(testForm.getTextInput(), expectedTextInputValue);
    }

    @Test
    public void testNumericInputValue() {
        Assert.assertEquals(testForm.getNumericInputValue(), expectedNumericInputValue);
    }

    @Test
    public void testNumericInputKey() {
        Assert.assertEquals(testForm.getNumericInputKey(), expectedNumericInputKey);
    }

    @Test
    public void testFile() {
        AsFormData fileData = testForm.getFile();
        Assert.assertEquals(fileData.getValue(), expectedFileValue);
        Assert.assertEquals(fileData.getKey(), expectedFileKey);
    }

    @Test
    public void testDoubleValue() {
        Assert.assertEquals(testForm.getDoubleValue(), Double.parseDouble(expectedDoubleValue));
    }

    @Test
    public void testIntegerValue() {
        Assert.assertEquals(testForm.getIntegerValue(), Integer.parseInt(expectedIntegerValue));
    }

    @Test
    public void testTableData() {
        List<TableCmp> tableData = testForm.getTableData();
        Assert.assertEquals(tableData.get(0).getTableInput(), expectedTableInputValueB1);
        Assert.assertEquals(tableData.get(1).getTableInput(), expectedTableInputValueB2);
    }

    @Test
    public void toAsfData() {
        AsFormWrapper asFormWrapper = asFormService.toAsfData(testForm);

        AsFormData textInput = asFormWrapper.getData("text_input");
        Assert.assertEquals(textInput.getType(), ComponentTypes.TEXT_BOX);
        Assert.assertEquals(textInput.getValue(), expectedTextInputValue);

        AsFormData tableCmp = asFormWrapper.getData("table_cmp");
        Assert.assertEquals(tableCmp.getData().size(), 4);
    }
}
