package kz.arta.synergy.api.asforms.utils;

import org.testng.Assert;
import org.testng.annotations.Test;

public class SearchIndexParamsBuilderTest {

    @Test
    public void testBuildWithOneExactParam() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .startRecord(2)
                .recordsCount(3)
                .exact("one", "value_one")
                .build();

        Assert.assertEquals(
            searchParams,
            "formUUID=123&field=one&search=value_one&type=exact&startRecord=2&recordsCount=3&term=and"
        );
    }

    @Test
    public void testBuildWithOnePartialParam() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .startRecord(2)
                .recordsCount(3)
                .partial("one", "value_one")
                .build();

        Assert.assertEquals(
                searchParams,
                "formUUID=123&field=one&search=value_one&type=partial&startRecord=2&recordsCount=3&term=and"
        );
    }

    @Test
    public void testBuildTermOr() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .termOr()
                .startRecord(2)
                .recordsCount(3)
                .partial("one", "value_one")
                .build();

        Assert.assertEquals(
                searchParams,
                "formUUID=123&field=one&search=value_one&type=partial&startRecord=2&recordsCount=3&term=or"
        );
    }

    @Test
    public void testBuildWithShowDeleted() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .exact("one", "value_one")
                .showDeleted(true)
                .build();

        Assert.assertEquals(
                searchParams,
                "formUUID=123&field=one&search=value_one&type=exact&showDeleted=true&term=and"
        );
    }

    @Test
    public void testBuildWithSearchInRegistry() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .exact("one", "value_one")
                .searchInRegistry(true)
                .build();

        Assert.assertEquals(
                searchParams,
                "formUUID=123&field=one&search=value_one&type=exact&searchInRegistry=true&term=and"
        );
    }

    @Test
    public void testBuildWithMultipleParams() throws Exception {
        String searchParams = SearchIndexParamsBuilder.newBuilder()
                .form("123")
                .startRecord(2)
                .recordsCount(3)
                .exact("one", "value_one")
                .partial("two", "value_two")
                .partial("three", "value_three")
                .exact("four", "value_four")
                .build();

        Assert.assertEquals(
                searchParams,
                "formUUID=123&field=one&search=value_one&type=exact&" +
                "formUUID1=123&field1=four&search1=value_four&type1=exact&" +
                "formUUID2=123&field2=two&search2=value_two&type2=partial&" +
                "formUUID3=123&field3=three&search3=value_three&type3=partial&" +
                        "startRecord=2&recordsCount=3&term=and"
        );
    }
}