package kz.arta.synergy.api.dictionaries;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.dictionaries.pojo.Dictionary;
import kz.arta.synergy.pojo.RatesDict;
import kz.arta.synergy.pojo.TestForm;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.io.IOException;
import java.net.URL;
import java.util.List;

/**
 * @author raimbek
 * @since 15.11.2016
 */
public class DictionaryServiceTest {

    @Test
    public void testGetDictionary() throws Exception {
        DictionaryService dictionaryServiceMock = Mockito.mock(DictionaryService.class);
        Mockito.when(dictionaryServiceMock.getDictionary("rates")).thenReturn(readDict());
        Mockito.when(dictionaryServiceMock.getDictionary(RatesDict.class)).thenCallRealMethod();

        List<RatesDict> rates = dictionaryServiceMock.getDictionary(RatesDict.class);

        Assert.assertEquals(rates.size(), 22);

        for (RatesDict rate : rates) {
            Assert.assertTrue(
                    rate.getYear().equals("2014") ||
                            rate.getYear().equals("2015") ||
                            rate.getYear().equals("2016")
            );
            Assert.assertTrue(rate.getGroup().equals("1") || rate.getGroup().equals("2"));
            Assert.assertNull(rate.getFieldWithoutAnnotation());
            Assert.assertNull(rate.getFieldWithWrongCodeAnnotation());
        }
    }

    @Test(expectedExceptions = DictionaryConvertException.class)
    public void testGetDictionaryWithoutAnnotation() throws Exception {
        DictionaryService dictionaryServiceMock = Mockito.mock(DictionaryService.class);
        Mockito.when(dictionaryServiceMock.getDictionary(TestForm.class)).thenCallRealMethod();

        dictionaryServiceMock.getDictionary(TestForm.class);
    }

    public Dictionary readDict() throws IOException {
        URL url = Resources.getResource("data/dictionary.json");
        return JsonUtils.read(Resources.toString(url, Charsets.UTF_8), Dictionary.class);
    }
}