package kz.arta.synergy.api.asforms.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.List;
import java.util.Map;

/**
 * @author raimbek
 * @since 25.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AsFormDefinition {
    private String uuid;
    private String version;
    private String typeform;
    private String name;
    private String nameru;
    private String namekz;
    private String code;
    private String description;
    private String type;
    private Map<String, String> config;
    private List<AsFormProperty> properties;

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTypeform() {
        return typeform;
    }

    public void setTypeform(String typeform) {
        this.typeform = typeform;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameru() {
        return nameru;
    }

    public void setNameru(String nameru) {
        this.nameru = nameru;
    }

    public String getNamekz() {
        return namekz;
    }

    public void setNamekz(String namekz) {
        this.namekz = namekz;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getConfig() {
        return config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public List<AsFormProperty> getProperties() {
        return properties;
    }

    public void setProperties(List<AsFormProperty> properties) {
        this.properties = properties;
    }

    public boolean hasCmp(String id) {
        for (AsFormProperty property : properties) {
            if (property.getId().equals(id)) {
                return true;
            }
            if (property.hasCmp(id)) {
                return true;
            }
        }
        return false;
    }
}
