package kz.arta.synergy.api.asforms.converter.components;

import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * Конвертор отдельных данных (компонентов)
 *
 * @author raimbek
 * @since 11.11.2016
 */
public interface ComponentConverter {

    /**
     * Преобразование поле на AsFormData
     * информация про id и тип берется их аннотаций
     * @param asForm    объект формы
     * @param field     поле
     * @param annotation    аннотация
     * @param index индекс, используется при конвертаций объекта таблицы
     * @param <T>   тип объекта формы
     * @return  AsFormData
     * @throws IllegalAccessException
     */
    <T> AsFormData toAsfData(T asForm, Field field, Annotation annotation, String index) throws IllegalAccessException;

    /**
     * Получение типа компонента synergy {@link kz.arta.synergy.api.asforms.pojo.ComponentTypes}
     * от аннотаций
     * @param annotation    аннотация
     * @return  тип компонента
     */
    String getType(Annotation annotation);

    /**
     * Получение id компонента от аннотаций
     * @param annotation    аннотация
     * @return  id компонента
     */
    String getCmpId(Annotation annotation);

    /**
     * Установить значение поле от данных формы
     * @param asfData   данные формы
     * @param asFormObject  java объект формы
     * @param field     поле соответствующее на данных форм
     * @param annotation    аннтоация поле
     * @param index индекс, если это поле данных таблицы
     * @param <T>   тип объекта формы
     * @throws IllegalAccessException
     */
    <T> void setFieldValue(AsFormDataContainer asfData, T asFormObject, Field field, Annotation annotation, String index) throws IllegalAccessException;
}
