package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;

import java.io.IOException;

/**
 * Created by: Abzal Kultayev
 * Date: 12.11.16
 * Time: 16:37
 */
public class StorageService {
    private final RestHttpQuery restHttpQuery;

    private StorageService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static StorageService newInstance(QueryContext context) {
        return new StorageService(context);
    }

    /**
     * Создает временный файл на сервере
     * @return Возвращает путь временного файла на сервере
     * @throws IOException
     */
    public String startUploadFile() throws IOException {
        Query query = Query.newInstance().url("/rest/api/storage/start_upload");
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.getValueByKey(result, "file");
    }

}
