# Работа с формами

## Объект формы

Форма должна наследовать класс AsForm. Компоненты описываются с помощью
аннотации.

Пример:

```
public class ExampleForm extends AsForm {

    @TextBox
    private String year;

    @NumericInput("sum_without_sale")
    private Double sumWithoutSale;

    @NumericInput
    private Double balance;

    @Table(id = "transactions", type = AccrualTransaction.class)
    private List<AccrualTransaction> transactions = new ArrayList<>();

    // ... ...
    // геттеры и сеттеры
}
```

А вот пример объекта таблицы, который используется выше:

```
public class AccrualTransaction {

    @DateCmp("date_t")
    private Date date;

    @NumericInput("sum_t")
    private Double sum;

    @TextBox("comment_t")
    private String comment;

    // ... ...
    // геттеры и сеттеры
}
```

Теперь этого объекта формы можем использовать следующим образом:

```
AsFormService formService = new AsFormService(context);
ExampleForm form = formService.getData(ExampleForm.class, "data uuid данных"; // получение данных:
form.setBalance(105.5d); // изменение
formService.saveData(form); // сохранение
```

Есть следующие виды аннотации:

- `TextBox` - однострочное поле
- `NumericInput` - числовое поле
- `DateCmp` - компонент дата/время
- `Counter` - счетчик
- `Entity` - объекты synergy
- `Radio` - ...
- `ListBox` - Компонент выбора варианта
- `Table` - динамическая таблица
- `Cmp` - универсальная аннотация для других копонентов форм. Используется следующим образом:

```
@Cmp(id = "company", type = ComponentTypes.REG_LINK)
private AsFormData company;
```

Класс AsFormData универсальное описание компонента формы. Его можно использовать с любой
аннотацией. Например:

```
@Entity
private AsFormData executor;
```

Есть специальная аннотация `@KeyValue` если его использовать вместе вышеперечисленными
аннотациями, то в качестве значения поле формы берется `key` а не `value`. Т.е. для всех компонентов,
кроме `NumericInput`, в качестве значения по умолчанию берется `value`. Аннотация особенно
полезно при использований `ListBox`:

Например:

```
@ListBox(id = "detailing_service", dictionary = ServiceDetailingDictionary.class)
@KeyValue
private Integer detailingService;
```

Во всех аннотациях если явно не указать id компонента, в качестве id берется название
поле.

Поддерживаемые типы полей:

- String
- Integer
- Double
- BigDecimal
- BigInteger
- AsFormData

Для компонента `DateCmp` формат по умолчанию такой `yyyy-MM-dd hh:mm:ss`. Но при использований
компонента можно указать свой формат:

```
@DateCmp(value = "date_t", format = "yyyy/MM hh:mm:ss")
private Date date;
```