package kz.arta.synergy.api.dictionaries.pojo;


import kz.arta.synergy.api.asforms.utils.Strings;

import java.util.Collections;
import java.util.List;

/**
 * @author raimbek
 * @since 26.04.2016
 */
public class Dictionary {
    private String dictionary_code;
    private String dictionaryID;
    private List<DictionaryColumn> columns;
    private List<DictionaryItem> items;

    public Dictionary() {
    }

    public String getDictionary_code() {
        return dictionary_code;
    }

    public void setDictionary_code(String dictionary_code) {
        this.dictionary_code = dictionary_code;
    }

    public String getDictionaryID() {
        return dictionaryID;
    }

    public void setDictionaryID(String dictionaryID) {
        this.dictionaryID = dictionaryID;
    }

    public List<DictionaryColumn> getColumns() {
        return columns;
    }

    public void setColumns(List<DictionaryColumn> columns) {
        this.columns = columns;
    }

    public List<DictionaryItem> getItems() {
        return items;
    }

    public void setItems(List<DictionaryItem> items) {
        this.items = items;
    }

    public String findColumnIdByCode(String columnCode) {
        for (DictionaryColumn column : columns) {
            if (!Strings.isNullOrEmpty(column.getCode()) && column.getCode().equals(columnCode)) {
                return column.getColumnID();
            }
        }
        return null;
    }

    public String findColumnCodeById(String columnID) {
        for (DictionaryColumn column : columns) {
            if (!Strings.isNullOrEmpty(column.getColumnID()) && column.getColumnID().equals(columnID)) {
                return column.getCode();
            }
        }
        return null;
    }

    public String findItemID(String columnID, String value) {
        for (DictionaryItem item : getItems()) {
            for (DictionaryItemValue itemValue : item.getValues()) {
                if (itemValue.getColumnID().equals(columnID) && itemValue.getValue().equals(value)) {
                    return item.getItemID();
                }
            }
        }
        return null;
    }

    public String getValue(String itemID, String columnID) {
        for (DictionaryItem item : getItems()) {
            if (item.getItemID().equals(itemID)) {
                for (DictionaryItemValue itemValue : item.getValues()) {
                    if (itemValue.getColumnID().equals(columnID)) {
                        return itemValue.getValue();
                    }
                }
                break;
            }
        }
        return "";
    }

    public DictionaryItem findItem(DictionaryItem srcDictItem) {
        for (DictionaryItem dictionaryItem : getItems()) {
            if (dictionaryItem.equals(srcDictItem)) {
                return dictionaryItem;
            }
        }
        return null;
    }
}
