package kz.arta.synergy.api.dictionaries.pojo;

/**
 * @author raimbek
 * @since 26.04.2016
 */
public class DictionaryItemValue implements Comparable<DictionaryItemValue> {
    private String columnID;
    private String value;

    public DictionaryItemValue() {
    }

    public String getColumnID() {
        return columnID;
    }

    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DictionaryItemValue itemValue = (DictionaryItemValue) o;

        if (columnID != null ? !columnID.equals(itemValue.columnID) : itemValue.columnID != null) return false;
        return !(value != null ? !value.equals(itemValue.value) : itemValue.value != null);

    }

    @Override
    public int hashCode() {
        int result = columnID != null ? columnID.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(DictionaryItemValue o) {
        if (o == null) {
            return 0;
        }
        return o.getColumnID().compareTo(this.columnID);
    }
}
