package kz.arta.synergy.api.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 23.01.2017
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SynergyDepartmentContent {

    private List<Department> departments = new ArrayList<Department>();
    private List<Position> positions = new ArrayList<Position>();

    public static class Department {
        public String departmentID;
        public String departmentName;
        public Boolean hasChildDepartments;
        public DepartmentHead departmentHead;
    }

    public static class DepartmentHead {
        public String headID;
        public String headName;
        public List<Position> positions;
    }

    public static class Position {
        public String positionID;
        public String positionName;
        public List<Employee> employees;
    }

    public static class Employee {
        public String employeeID;
        public String employeeName;
    }

    public List<Department> getDepartments() {
        return departments;
    }

    public void setDepartments(List<Department> departments) {
        this.departments = departments;
    }

    public List<Position> getPositions() {
        return positions;
    }

    public void setPositions(List<Position> positions) {
        this.positions = positions;
    }
}
