package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.PersonalRecordForm;
import kz.arta.synergy.api.pojo.SynergyUser;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class PersonalRecordService {

    private final RestHttpQuery restHttpQuery;

    private PersonalRecordService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static PersonalRecordService newInstance(QueryContext queryContext) {
        return new PersonalRecordService(queryContext);
    }

    public List<PersonalRecordForm> getForms(String userId) throws IOException {
        Query query = Query.newInstance().url("/rest/api/personalrecord/forms/" + userId);
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<PersonalRecordForm>>() {});
    }
}
