package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.asforms.pojo.RegistryRecord;
import kz.arta.synergy.api.pojo.Registry;

import java.io.IOException;

/**
 * Created by: Abzal Kultayev
 * DateCmp: 11.11.16
 * Time: 18:17
 */
public class RegistryService {

    private final RestHttpQuery restHttpQuery;

    private RegistryService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static RegistryService newInstance(QueryContext context) {
        return new RegistryService(context);
    }

    public RegistryRecord createRegistryRecord(String registryID) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/registry/create_doc")
                .queryParam("registryID", registryID);
        String response = restHttpQuery.doQuery(query);
        return JsonUtils.read(response, RegistryRecord.class);
    }

    public String activateRecord(String dataUUID) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/registry/activate_doc")
                .queryParam("dataUUID", dataUUID);
        return restHttpQuery.doQuery(query);
    }

    public String deleteRecord(String dataUUID) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/registry/delete_doc")
                .queryParam("dataUUID", dataUUID);
        return restHttpQuery.doQuery(query);
    }

    public Registry getRegistry(String code) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/registry/info")
                .queryParam("code", code);
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, Registry.class);
    }
}
