package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyUser;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class UserChooserService {

    public static class User {
        public String userID;
        public String name;
        public String position;
    }

    public static class SearchExtUser {
        public String personName;
        public String personID;
        public String departmentName;
        public String positionName;
        public Object customFields;
        public String lastname;
        public String firstname;
        public String patronymic;
    }

    private final RestHttpQuery restHttpQuery;
    private UserService userService;

    private UserChooserService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
        userService = UserService.newInstance(context);
    }

    public static UserChooserService newInstance(QueryContext queryContext) {
        return new UserChooserService(queryContext);
    }

    public List<User> getUsers(String search) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/userchooser/search")
                .queryParam("search", search)
                .queryParam("showAll", true)
                .queryParam("recordsCount", 10000);
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<User>>() {});
    }

    public List<SearchExtUser> getUsersExt(String search) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/userchooser/search_ext")
                .queryParam("search", search)
                .queryParam("showAll", true)
                .queryParam("showNoPosition", true)
                .queryParam("recordsCount", 10000);
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<SearchExtUser>>() {});
    }

    public List<SearchExtUser> getPositionUsers(String positionId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/userchooser/search_ext")
                .queryParam("filterPositionID", positionId)
                .queryParam("showAll", true)
                .queryParam("recordsCount", 0);
        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<SearchExtUser>>() {});
    }

    public SynergyUser findUserByCode(String searchString, String code) throws IOException {
        List<SearchExtUser> users = getUsersExt(searchString);

        for (SearchExtUser user : users) {
            SynergyUser userInfo = userService.getUserInfo(user.personID);
            if (code.equals(userInfo.getCode())) {
                return userInfo;
            }
        }
        return null;
    }
}
