package kz.arta.synergy.api;

import javax.xml.bind.DatatypeConverter;

/**
 * Created by: Abzal Kultayev
 * DateCmp: 07.11.16
 * Time: 15:11
 *
 * Контекст для запросов
 */
public class QueryContext {
    /**
     * Адрес сервера
     */
    private String address;

    /**
     * Логин пользователя
     */
    private String login;
    /**
     * Пароль пользователя
     */
    private String password;

    public QueryContext(String address) {
        this.address = address;
    }

    public QueryContext(String address, String login, String password) {
        this.address = address;
        this.login = login;
        this.password = password;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAuthHeader() {
        return DatatypeConverter.printBase64Binary((getLogin() + ":" + getPassword()).getBytes());
    }

}
