package kz.arta.synergy.api.asforms.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 10.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AsFormDataContainer {

    private List<AsFormData> data;

    public AsFormDataContainer() {
    }

    public AsFormData getData(String cmpId) {
        if (getData() == null || getData().isEmpty()) {
            return null;
        }
        for (AsFormData asFormData : getData()) {
            if (asFormData.getId() != null && asFormData.getId().equalsIgnoreCase(cmpId)) {
                return asFormData;
            }
        }
        return null;
    }

    public String getValueFromInnerData(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    public String getValueFromInnerData(String cmpId, String defaultValue) {
        String value = getValueFromInnerData(cmpId);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getKeyFromInnerData(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getKey();
        }
        return null;
    }

    public String getKeyFromInnerData(String cmpId, String defaultKey) {
        String key = getKeyFromInnerData(cmpId);
        if (key == null) {
            return defaultKey;
        }
        return key;
    }

    public List<AsFormData> getData() {
        return data;
    }

    public void setData(List<AsFormData> data) {
        this.data = data;
    }

    public void addData(AsFormData data) {
        if (this.data == null) {
            this.data = new ArrayList<>();
        }
        this.data.add(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AsFormDataContainer that = (AsFormDataContainer) o;

        return !(data != null ? !data.equals(that.data) : that.data != null);

    }

    @Override
    public int hashCode() {
        return data != null ? data.hashCode() : 0;
    }
}
