package kz.arta.synergy.api.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

/**
 * @author raimbek
 * @since 23.01.2017
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SynergyManager {
    private String positionId;
    private String nameRu;
    private String nameKz;
    private String nameEn;
    private String pointersCode;

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getNameRu() {
        return nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SynergyManager that = (SynergyManager) o;

        if (positionId != null ? !positionId.equals(that.positionId) : that.positionId != null) return false;
        if (nameRu != null ? !nameRu.equals(that.nameRu) : that.nameRu != null) return false;
        if (nameKz != null ? !nameKz.equals(that.nameKz) : that.nameKz != null) return false;
        if (nameEn != null ? !nameEn.equals(that.nameEn) : that.nameEn != null) return false;
        return !(pointersCode != null ? !pointersCode.equals(that.pointersCode) : that.pointersCode != null);

    }

    @Override
    public int hashCode() {
        int result = positionId != null ? positionId.hashCode() : 0;
        result = 31 * result + (nameRu != null ? nameRu.hashCode() : 0);
        result = 31 * result + (nameKz != null ? nameKz.hashCode() : 0);
        result = 31 * result + (nameEn != null ? nameEn.hashCode() : 0);
        result = 31 * result + (pointersCode != null ? pointersCode.hashCode() : 0);
        return result;
    }
}
