package kz.arta.synergy.api.pojo;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 08.08.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SynergyUser {
    private String userid;
    private String lastname;
    private String firstname;
    private String patronymic;
    private String mail;
    private String jid;
    private String code;
    private String access;
    private String admin;
    private String configurator;
    private String modified;
    private List<SynergyPosition> positions = new ArrayList<>();

    @JsonIgnore
    private String login;

    @JsonIgnore
    private String password;

    @JsonIgnore
    private String privateFolder;

    public SynergyUser() {
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getLastname() {
        return lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getFirstname() {
        return firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getPatronymic() {
        return patronymic;
    }

    public void setPatronymic(String patronymic) {
        this.patronymic = patronymic;
    }

    public String getMail() {
        return mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getJid() {
        return jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAccess() {
        return access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public String getAdmin() {
        return admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getConfigurator() {
        return configurator;
    }

    public void setConfigurator(String configurator) {
        this.configurator = configurator;
    }

    public String getModified() {
        return modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public List<SynergyPosition> getPositions() {
        return positions;
    }

    public void setPositions(List<SynergyPosition> positions) {
        this.positions = positions;
    }

    public String getFIO() {
        String result = lastname;
        if (firstname != null) {
            result += " " + firstname;
        }
        return result;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPrivateFolder() {
        return privateFolder;
    }

    public void setPrivateFolder(String privateFolder) {
        this.privateFolder = privateFolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SynergyUser that = (SynergyUser) o;

        if (userid != null ? !userid.equals(that.userid) : that.userid != null) return false;
        if (lastname != null ? !lastname.equals(that.lastname) : that.lastname != null) return false;
        if (firstname != null ? !firstname.equals(that.firstname) : that.firstname != null) return false;
        if (patronymic != null ? !patronymic.equals(that.patronymic) : that.patronymic != null) return false;
        if (mail != null ? !mail.equals(that.mail) : that.mail != null) return false;
        if (jid != null ? !jid.equals(that.jid) : that.jid != null) return false;
        if (code != null ? !code.equals(that.code) : that.code != null) return false;
        if (access != null ? !access.equals(that.access) : that.access != null) return false;
        if (admin != null ? !admin.equals(that.admin) : that.admin != null) return false;
        if (configurator != null ? !configurator.equals(that.configurator) : that.configurator != null) return false;
        if (modified != null ? !modified.equals(that.modified) : that.modified != null) return false;
        if (positions != null ? !positions.equals(that.positions) : that.positions != null) return false;
        if (login != null ? !login.equals(that.login) : that.login != null) return false;
        if (password != null ? !password.equals(that.password) : that.password != null) return false;
        return !(privateFolder != null ? !privateFolder.equals(that.privateFolder) : that.privateFolder != null);

    }

    @Override
    public int hashCode() {
        int result = userid != null ? userid.hashCode() : 0;
        result = 31 * result + (lastname != null ? lastname.hashCode() : 0);
        result = 31 * result + (firstname != null ? firstname.hashCode() : 0);
        result = 31 * result + (patronymic != null ? patronymic.hashCode() : 0);
        result = 31 * result + (mail != null ? mail.hashCode() : 0);
        result = 31 * result + (jid != null ? jid.hashCode() : 0);
        result = 31 * result + (code != null ? code.hashCode() : 0);
        result = 31 * result + (access != null ? access.hashCode() : 0);
        result = 31 * result + (admin != null ? admin.hashCode() : 0);
        result = 31 * result + (configurator != null ? configurator.hashCode() : 0);
        result = 31 * result + (modified != null ? modified.hashCode() : 0);
        result = 31 * result + (positions != null ? positions.hashCode() : 0);
        result = 31 * result + (login != null ? login.hashCode() : 0);
        result = 31 * result + (password != null ? password.hashCode() : 0);
        result = 31 * result + (privateFolder != null ? privateFolder.hashCode() : 0);
        return result;
    }
}
