package kz.arta.synergy.api;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

/**
 * Created by: Abzal Kultayev
 * Date: 07.11.16
 * Time: 15:08
 */
public class RestHttpQuery {
    public static final int TIMEOUT = 10*60*1000;

    private QueryContext context;

    public RestHttpQuery(QueryContext context) {
        this.context = context;
    }

    public String doQuery(Query query) throws IOException {
        URL url = new URL(context.getAddress() + makeQuery(query.getUrl(), query.getQueryParams()));
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setConnectTimeout(TIMEOUT);
        conn.setReadTimeout(TIMEOUT);
        conn.setRequestMethod(query.getMethod());

        Map<String, String> headers = query.getHeaders();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        authentication(conn);

        conn.setUseCaches(true);
        conn.setDoInput(true);

        if (query.getMethod().equals("POST")) {
            conn.setDoOutput(true);

            DataOutputStream request = new DataOutputStream(conn.getOutputStream());
            if (!query.getFormParams().isEmpty()) {
                request.write(joinParamsForQuery(query.getFormParams()).getBytes("UTF-8"));
            } else if (!Strings.isNullOrEmpty(query.getBody())) {
                request.write(query.getBody().getBytes("UTF-8"));
            }

            request.flush();
            request.close();
        }
        return readStringReturn(conn);

    }

    /*public String doPostQuery() {

    }*/

    private String makeQuery(String query, Map<String, ?> params) {
        String joined = joinParamsForQuery(params);
        if (!joined.isEmpty()) return query + "?" + joined;
        return query;
    }

    private String joinParamsForQuery(Map<String, ?> params) {
        if (params == null) return "";

        return FluentIterable.from(params.entrySet()).transform(
                new Function<Map.Entry<String, ?>, String>() {
                    @Override
                    public String apply(Map.Entry<String, ?> input) {
                        String value = input.getValue().toString();
                        try {
                            value = URLEncoder.encode(value, "UTF-8");
                        } catch (UnsupportedEncodingException e) {
                            value = null;
                        }
                        if (value == null || value.isEmpty()) return null;
                        return input.getKey() + "=" + value;
                    }
                }).filter(Predicates.notNull()).join(Joiner.on("&"));
    }

    private String readStringReturn(HttpURLConnection conn) throws IOException {
        String output;
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));

        while ((output = br.readLine()) != null) {
            result.append(output);
        }
        conn.disconnect();
        return result.toString();
    }

    private void authentication(HttpURLConnection conn) {
        if (context.getLogin() != null && context.getPassword() != null) {
            conn.setRequestProperty("Authorization", "Basic " + context.getAuthHeader());
        }
    }
}
