package kz.arta.synergy.api.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

/**
 * @author raimbek
 * @since 08.08.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SynergyDepartment {

    private String departmentID;
    private String parentDepartmentID;
    private String nameRu;
    private String nameKz;
    private String nameEn;
    private String pointersCode;
    private String number;
    private SynergyManager manager;

    public SynergyDepartment() {
    }

    public String getDepartmentID() {
        return departmentID;
    }

    public void setDepartmentID(String departmentID) {
        this.departmentID = departmentID;
    }

    public String getParentDepartmentID() {
        return parentDepartmentID;
    }

    public void setParentDepartmentID(String parentDepartmentID) {
        this.parentDepartmentID = parentDepartmentID;
    }

    public SynergyManager getManager() {
        return manager;
    }

    public void setManager(SynergyManager manager) {
        this.manager = manager;
    }

    public String getNameRu() {
        return nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SynergyDepartment that = (SynergyDepartment) o;

        if (departmentID != null ? !departmentID.equals(that.departmentID) : that.departmentID != null) return false;
        if (parentDepartmentID != null ? !parentDepartmentID.equals(that.parentDepartmentID) : that.parentDepartmentID != null)
            return false;
        if (nameRu != null ? !nameRu.equals(that.nameRu) : that.nameRu != null) return false;
        if (nameKz != null ? !nameKz.equals(that.nameKz) : that.nameKz != null) return false;
        if (nameEn != null ? !nameEn.equals(that.nameEn) : that.nameEn != null) return false;
        if (pointersCode != null ? !pointersCode.equals(that.pointersCode) : that.pointersCode != null) return false;
        if (number != null ? !number.equals(that.number) : that.number != null) return false;
        return !(manager != null ? !manager.equals(that.manager) : that.manager != null);

    }

    @Override
    public int hashCode() {
        int result = departmentID != null ? departmentID.hashCode() : 0;
        result = 31 * result + (parentDepartmentID != null ? parentDepartmentID.hashCode() : 0);
        result = 31 * result + (nameRu != null ? nameRu.hashCode() : 0);
        result = 31 * result + (nameKz != null ? nameKz.hashCode() : 0);
        result = 31 * result + (nameEn != null ? nameEn.hashCode() : 0);
        result = 31 * result + (pointersCode != null ? pointersCode.hashCode() : 0);
        result = 31 * result + (number != null ? number.hashCode() : 0);
        result = 31 * result + (manager != null ? manager.hashCode() : 0);
        return result;
    }
}
