package kz.arta.synergy.api.asforms.converter.components;

import com.google.common.base.Strings;
import kz.arta.synergy.api.asforms.annotations.DateCmp;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;
import kz.arta.synergy.api.asforms.pojo.ComponentTypes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author raimbek
 * @since 11.11.2016
 */
public class DateConverter extends AbstractComponentConverter {

    @Override
    public <T> AsFormData toAsfData(T asForm, Field field, Annotation annotation, String index) throws IllegalAccessException {
        AsFormData asFormData = super.toAsfData(asForm, field, annotation, index);

        if (field.getType().isAssignableFrom(Date.class)) {
            Date date = (Date) field.get(asForm);
            if (date == null) {
                return asFormData;
            }
            String dateFormat = getDateFormat(annotation);
            try {
                String dateValue = new SimpleDateFormat(dateFormat).format(date);
                asFormData.setValue(dateValue);
                asFormData.setKey(dateValue);
            } catch (Exception ex) {
                return asFormData;
            }
        } else {
            asFormData.setKey(String.valueOf(field.get(asForm)));
        }
        return asFormData;
    }

    @Override
    public <T> void setFieldValue(AsFormDataContainer asfData, T asFormObject, Field field, Annotation annotation, String index) throws Exception {
        if (field.getType().isAssignableFrom(Date.class)) {
            field.setAccessible(true);
            String cmpId = getCmpId(field, annotation, index);
            AsFormData data = asfData.getData(cmpId);

            if (data == null) {
                return;
            }

            String dateString;
            if (ComponentTypes.DATE.equals(data.getType()) || hasKeyValueAnnotation(field)) {
                dateString = data.getKey();
            } else {
                dateString = data.getValue();
            }

            if(!Strings.isNullOrEmpty(dateString)) {
                String dateFormat = getDateFormat(annotation);
                Date date = new SimpleDateFormat(dateFormat).parse(dateString);
                field.set(asFormObject, date);
            }
        } else {
            super.setFieldValue(asfData, asFormObject, field, annotation, index);
        }
    }

    private String getDateFormat(Annotation annotation) {
        return ((DateCmp) annotation).format();
    }

    @Override
    public String getType(Annotation annotation) {
        return ComponentTypes.DATE;
    }

    @Override
    public String getCmpId(Annotation annotation) {
        return ((DateCmp) annotation).value();
    }
}
