package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyUser;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class UserService {

    private final RestHttpQuery restHttpQuery;

    private UserService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static UserService newInstance(QueryContext queryContext) {
        return new UserService(queryContext);
    }

    public String saveUser(SynergyUser synergyUser) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .url("/rest/api/filecabinet/user/save")
                .formParam("userID", synergyUser.getUserid())
                .formParam("lastname", synergyUser.getLastname())
                .formParam("firstname", synergyUser.getFirstname())
                .formParam("patronymic", synergyUser.getPatronymic())
                .formParam("pointersCode", synergyUser.getCode())
                .formParam("email", synergyUser.getMail())
                .formParam("privateFolder", synergyUser.getPrivateFolder())
                .formParam("hasAccess", synergyUser.getAccess());
        return restHttpQuery.doQuery(query);
    }

    public SynergyUser getUserInfo(String userID) throws IOException {
        String result = restHttpQuery.doQuery(Query.newInstance().url("/rest/api/filecabinet/user/" + userID));
        return JsonUtils.read(result, SynergyUser.class);
    }
}
