package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.DocSend;
import kz.arta.synergy.api.pojo.DocumentInfo;
import kz.arta.synergy.api.pojo.SynergyDepartment;
import kz.arta.synergy.api.pojo.SynergyDepartmentContent;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class DepartmentsService {

    private final RestHttpQuery restHttpQuery;

    private DepartmentsService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static DepartmentsService newInstance(QueryContext queryContext) {
        return new DepartmentsService(queryContext);
    }

    public SynergyDepartment getDepartment(String departmentId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/get")
                .queryParam("departmentID", departmentId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyDepartment.class);
    }

    public SynergyDepartmentContent getDepartmentsContent(String departmentId, Boolean onlyPosition, Boolean onlyDepartments) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/content")
                .queryParam("onlyPosition", onlyPosition)
                .queryParam("onlyDepartments", onlyDepartments)
                .queryParam("departmentID", departmentId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyDepartmentContent.class);
    }
}
