package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyDepartment;
import kz.arta.synergy.api.pojo.SynergyDepartmentContent;
import kz.arta.synergy.api.pojo.SynergyPosition;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class PositionsService {

    private final RestHttpQuery restHttpQuery;

    private PositionsService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static PositionsService newInstance(QueryContext queryContext) {
        return new PositionsService(queryContext);
    }

    public SynergyPosition getPosition(String positionId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/get")
                .queryParam("positionID", positionId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyPosition.class);
    }

}
