package kz.arta.synergy.api;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

/**
 * Created by: Abzal Kultayev
 * Date: 07.11.16
 * Time: 15:08
 */
public class RestHttpQuery {
    public static final int TIMEOUT = 10*60*1000;

    public String doGetQuery(QueryContext context, String query) throws IOException {
        URL url = new URL(context.getAddress() + query);
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setConnectTimeout(TIMEOUT);
        conn.setReadTimeout(TIMEOUT);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json; charset=utf-8");
        authentication(context, conn);
        return readStringReturn(conn);

    }

    public String doGetQuery(QueryContext context, String query, Map<String, ?> params) throws IOException {
        return doGetQuery(context, makeQuery(query, params));
    }

    private String makeQuery(String query, Map<String, ?> params) {
        String joined = joinParamsForQuery(params);
        if (!joined.isEmpty()) return query + "?" + joined;
        return query;
    }

    private String joinParamsForQuery(Map<String, ?> params) {
        if (params == null) return "";

        return FluentIterable.from(params.entrySet()).transform(
                new Function<Map.Entry<String, ?>, String>() {
                    @Override
                    public String apply(Map.Entry<String, ?> input) {
                        String value = input.getValue().toString();
                        try {
                            value = URLEncoder.encode(value, "UTF-8");
                        } catch (UnsupportedEncodingException e) {
                            value = null;
                        }
                        if (value == null || value.isEmpty()) return null;
                        return input.getKey() + "=" + value;
                    }
                }).filter(Predicates.notNull()).join(Joiner.on("&"));
    }

    private String readStringReturn(HttpURLConnection conn) throws IOException {
        String output;
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));

        while ((output = br.readLine()) != null) {
            result.append(output);
        }
        conn.disconnect();
        return result.toString();
    }

    private void authentication(QueryContext context, HttpURLConnection conn) {
        if (context.getLogin() != null && context.getPassword() != null) {
            conn.setRequestProperty("Authorization", "Basic " + context.getAuthHeader());
        }
    }
}
