package kz.arta.synergy.api.asforms.pojo;

import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 10.11.2016
 */
public class AsFormDataContainer {

    private List<AsFormData> data;

    public AsFormDataContainer() {
    }

    public AsFormData getData(String cmpId) {
        if (getData() == null || getData().isEmpty()) {
            return null;
        }
        for (AsFormData asFormData : getData()) {
            if (asFormData.getId() != null && asFormData.getId().equalsIgnoreCase(cmpId)) {
                return asFormData;
            }
        }
        return null;
    }

    public String getValue(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    public String getKey(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getKey();
        }
        return null;
    }

    public List<AsFormData> getData() {
        return data;
    }

    public void setData(List<AsFormData> data) {
        this.data = data;
    }

    public void addData(AsFormData data) {
        if (this.data == null) {
            this.data = new ArrayList<>();
        }
        this.data.add(data);
    }
}
