package kz.arta.synergy.api.asforms.converter.components;

import kz.arta.synergy.api.asforms.annotations.Radio;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.ComponentTypes;
import kz.arta.synergy.api.asforms.pojo.ListBoxDictionary;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * @author raimbek
 * @since 11.11.2016
 */
public class RadioConverter extends AbstractComponentConverter {

    @Override
    public <T> AsFormData toAsfData(T asForm, Field field, Annotation annotation, String index) throws IllegalAccessException {
        field.setAccessible(true);
        String cmpId = getCmpId(field, annotation, index);

        AsFormData asFormData = AsFormData.create(cmpId, getType(annotation));

        Object valueObject = field.get(asForm);
        if (valueObject instanceof AsFormData) {
            AsFormData asFormDataObject = (AsFormData) valueObject;
            asFormDataObject.setId(cmpId);
            asFormDataObject.setType(getType(annotation));
            return asFormDataObject;
        } else {
            String value = String.valueOf(valueObject);
            try {
                ListBoxDictionary listBoxDictionary = ((Radio) annotation).dictionary().newInstance();
                if (hasKeyValueAnnotation(field)) {
                    asFormData.setKey(value);
                    asFormData.setValue(listBoxDictionary.getValue(value));
                } else {
                    asFormData.setValue(value);
                    asFormData.setKey(listBoxDictionary.getValue(value));
                }
            } catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return asFormData;
    }

    @Override
    public String getType(Annotation annotation) {
        return ComponentTypes.RADIO;
    }

    @Override
    public String getCmpId(Annotation annotation) {
        return ((Radio) annotation).id();
    }
}
