package kz.arta.synergy.api.asforms.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 10.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AsFormDataContainer {

    private List<AsFormData> data;

    public AsFormDataContainer() {
    }

    public AsFormData getData(String cmpId) {
        if (getData() == null || getData().isEmpty()) {
            return null;
        }
        for (AsFormData asFormData : getData()) {
            if (asFormData.getId() != null && asFormData.getId().equalsIgnoreCase(cmpId)) {
                return asFormData;
            }
        }
        return null;
    }

    public String getValue(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    public String getValue(String cmpId, String defaultValue) {
        String value = getValue(cmpId);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getKey(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getKey();
        }
        return null;
    }

    public String getKey(String cmpId, String defaultKey) {
        String key = getKey(cmpId);
        if (key == null) {
            return defaultKey;
        }
        return key;
    }

    public List<AsFormData> getData() {
        return data;
    }

    public void setData(List<AsFormData> data) {
        this.data = data;
    }

    public void addData(AsFormData data) {
        if (this.data == null) {
            this.data = new ArrayList<>();
        }
        this.data.add(data);
    }
}
