package kz.arta.synergy.api.asforms;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.asforms.converter.AsFormConverter;
import kz.arta.synergy.api.asforms.converter.DefaultAsFormConverter;
import kz.arta.synergy.api.asforms.pojo.AdvancedSearchParams;
import kz.arta.synergy.api.asforms.pojo.AdvancedSearchResult;
import kz.arta.synergy.api.asforms.pojo.AsForm;
import kz.arta.synergy.api.asforms.pojo.AsFormWrapper;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
public class AsFormService {

    private RestHttpQuery restHttpQuery;
    private AsFormConverter asFormConverter;

    private AsFormService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static AsFormService newInstance(QueryContext context) {
        AsFormService asFormService = new AsFormService(context);
        asFormService.asFormConverter = new DefaultAsFormConverter();
        return asFormService;
    }

    public RestHttpQuery getRestHttpQuery() {
        return restHttpQuery;
    }

    public AsFormService setRestHttpQuery(RestHttpQuery restHttpQuery) {
        this.restHttpQuery = restHttpQuery;
        return this;
    }

    public AsFormService setFormConverter(AsFormConverter converter) {
        this.asFormConverter = converter;
        return this;
    }

    public List<AdvancedSearchResult> advancedSearch(AdvancedSearchParams searchParams) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .header("Content-Type", "application/json; charset=utf-8")
                .url("/rest/api/asforms/search/advanced")
                .body(JsonUtils.toJson(searchParams));

        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<AdvancedSearchResult>>() {});
    }

    public List<AdvancedSearchResult> advancedSearch(String formId, String key, String value) throws IOException {
        return advancedSearch(AdvancedSearchParams.build(
            String.format("where uuid='%s' and %s='%s'", formId, key, value), key
        ));
    }

    public <T extends AsForm> T getData(Class<T> formClass, String dataUUID) throws IOException {
        return asFormConverter.toAsForm(formClass, getData(dataUUID));
    }

    public AsFormWrapper getData(String dataUUID) throws IOException {
        String data = restHttpQuery.doQuery(Query.newInstance().url("/rest/api/asforms/data/" + dataUUID));
        return JsonUtils.read(data, AsFormWrapper.class);
    }

    public String saveData(AsFormWrapper asFormWrapper) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .url("/rest/api/asforms/data/save")
                .formParam("formUUID", asFormWrapper.getForm())
                .formParam("uuid", asFormWrapper.getUuid())
                .formParam("data", "\"data\":" + JsonUtils.toJson(asFormWrapper.getData()));

        return restHttpQuery.doQuery(query);
    }

    public <T extends AsForm> String saveData(T asForm) throws IOException {
        return saveData(asFormConverter.toAsfData(asForm));
    }

    public <T extends AsForm> AsFormWrapper toAsfData(T asForm) {
        return asFormConverter.toAsfData(asForm);
    }
}
