package kz.arta.synergy.api;

import kz.arta.synergy.api.asforms.utils.Strings;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;

/**
 * Created by: Abzal Kultayev
 * DateCmp: 07.11.16
 * Time: 15:08
 */
public class RestHttpQuery {
    public static final int TIMEOUT = 10*60*1000;

    private QueryContext context;

    public RestHttpQuery(QueryContext context) {
        this.context = context;
    }

    private HttpURLConnection doQueryAndReturnConnection(Query query) throws IOException {
        URL url = new URL(context.getAddress() + makeQuery(query.getUrl(), query.getQueryParams()));
        HttpURLConnection conn = (HttpURLConnection) url.openConnection();
        conn.setConnectTimeout(TIMEOUT);
        conn.setReadTimeout(TIMEOUT);
        conn.setRequestMethod(query.getMethod());

        Map<String, String> headers = query.getHeaders();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        authentication(conn);

        conn.setUseCaches(true);
        conn.setDoInput(true);

        if (query.getMethod().equals("POST")) {
            conn.setDoOutput(true);

            DataOutputStream request = new DataOutputStream(conn.getOutputStream());
            if (!query.getFormParams().isEmpty()) {
                String params = joinParamsForQuery(query.getFormParams());
                request.write(params.getBytes("UTF-8"));
            } else if (!Strings.isNullOrEmpty(query.getBody())) {
                request.write(query.getBody().getBytes("UTF-8"));
            }

            request.flush();
            request.close();
        }
        return conn;
    }

    public String doQuery(Query query) throws IOException {
        HttpURLConnection conn = doQueryAndReturnConnection(query);
        return readStringReturn(conn);
    }

    public String doQuery(String url) throws IOException {
        return doQuery(Query.newInstance().url(url));
    }

    public byte[] doQueryAndReturnBytes(Query query) throws IOException {
        HttpURLConnection conn = doQueryAndReturnConnection(query);
        InputStream is = conn.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        int nRead;
        byte[] data = new byte[16384];

        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }

        buffer.flush();

        return buffer.toByteArray();
    }

    private String makeQuery(String query, Map<String, ?> params) {
        String joined = joinParamsForQuery(params);
        if (!joined.isEmpty()) return query + "?" + joined;
        return query;
    }

    public String joinParamsForQuery(Map<String, ?> params) {
        if (params == null) return "";

        String result = "";
        for (Map.Entry<String, ?> param : params.entrySet()) {

            if (param.getValue() == null || param.getValue().toString().isEmpty()) {
                continue;
            }

            String value;
            try {
                value = URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8");
            } catch (UnsupportedEncodingException e) {
                value = null;
            }

            result += param.getKey() + "=" + value + "&";
        }

        return result.substring(0, result.length() - 1);
    }

    private String readStringReturn(HttpURLConnection conn) throws IOException {
        String output;
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));

        while ((output = br.readLine()) != null) {
            result.append(output);
        }
        conn.disconnect();
        return result.toString();
    }

    private void authentication(HttpURLConnection conn) {
        if (context.getLogin() != null && context.getPassword() != null) {
            conn.setRequestProperty("Authorization", "Basic " + context.getAuthHeader());
        }
    }
}
