package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;

import java.io.IOException;

/**
 * Created by: Abzal Kultayev
 * DateCmp: 11.11.16
 * Time: 18:17
 */
public class RegistryService {

    private final RestHttpQuery restHttpQuery;

    private RegistryService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static RegistryService newInstance(QueryContext context) {
        return new RegistryService(context);
    }

    public String createRegistryRecord(String registryID) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/registry/create_doc")
                .queryParam("registryID", registryID);
        String response = restHttpQuery.doQuery(query);
        return JsonUtils.readTree(response).get("dataUUID").getTextValue();
    }

    public void activateRecord(String dataUUID) {

    }
}
