package kz.arta.synergy.api.asforms;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.asforms.converter.AsfFormConverter;
import kz.arta.synergy.api.asforms.converter.DefaultAsfFormConverter;
import kz.arta.synergy.api.asforms.pojo.AdvancedSearchParams;
import kz.arta.synergy.api.asforms.pojo.AdvancedSearchResult;
import kz.arta.synergy.api.asforms.pojo.AsForm;
import kz.arta.synergy.api.asforms.pojo.AsFormWrapper;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
public class AsFormService {

    private RestHttpQuery restHttpQuery;
    private AsfFormConverter asfFormConverter;

    private AsFormService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static AsFormService newInstance(QueryContext context) {
        AsFormService asFormService = new AsFormService(context);
        asFormService.asfFormConverter = new DefaultAsfFormConverter();
        return asFormService;
    }

    public List<AdvancedSearchResult> advancedSearch(AdvancedSearchParams searchParams) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .header("Content-Type", "application/json; charset=utf-8")
                .url("/rest/api/asforms/search/advanced")
                .body(JsonUtils.toJson(searchParams));

        String result = restHttpQuery.doQuery(query);
        return JsonUtils.read(result, new TypeReference<List<AdvancedSearchResult>>() {});
    }

    public List<AdvancedSearchResult> advancedSearch(String formId, String key, String value) throws IOException {
        return advancedSearch(AdvancedSearchParams.build(
                String.format("where uuid='%s' and %s='%s'", formId, key, value), key
        ));
    }

    public <T extends AsForm> T fetch(Class<T> formClass, String dataUUID) throws IOException {
        String data = restHttpQuery.doQuery(Query.newInstance().url("/rest/api/asforms/data/" + dataUUID));
        return asfFormConverter.toAsForm(formClass, JsonUtils.read(data, AsFormWrapper.class));
    }

    public <T extends AsForm> String save(T asForm) throws IOException {
        AsFormWrapper asFormWrapper = asfFormConverter.toAsfData(asForm);

        Query query = Query.newInstance()
            .methodPost()
            .url("/rest/api/asforms/data/save")
            .formParam("formUUID", asForm.getForm())
            .formParam("uuid", asForm.getUuid())
            .formParam("data", "\"data\":" + JsonUtils.toJson(asFormWrapper.getData()));

        return restHttpQuery.doQuery(query);
    }

    public <T extends AsForm> AsFormWrapper toAsfData(T asForm) {
        return asfFormConverter.toAsfData(asForm);
    }

    public RestHttpQuery getRestHttpQuery() {
        return restHttpQuery;
    }

    public AsFormService setRestHttpQuery(RestHttpQuery restHttpQuery) {
        this.restHttpQuery = restHttpQuery;
        return this;
    }
}
