package kz.arta.synergy.asforms;

import kz.arta.synergy.asforms.annotations.*;
import kz.arta.synergy.asforms.exceptions.CreateAsFormException;
import kz.arta.synergy.asforms.exceptions.SynergyApiCallException;
import kz.arta.synergy.asforms.exceptions.UnsupportedFieldTypeException;
import kz.arta.synergy.asforms.pojo.AsForm;
import kz.arta.synergy.asforms.pojo.AsFormData;
import kz.arta.synergy.asforms.pojo.ComponentTypes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
public class AsFormProvider {

    private SynergyApiProvider synergyApiProvider;

    public AsFormProvider() {
    }

    public AsFormProvider(SynergyApiProvider synergyApiProvider) {
        this.synergyApiProvider = synergyApiProvider;
    }

    public <T extends AsForm>
    List<AdvancedSearchResult<T>>
    advancedSearch(Class<T> formClass, AdvancedSearchParams advancedSearchParams)
    {
        return new ArrayList<AdvancedSearchResult<T>>();
    }

    public <T extends AsForm>
    T
    fetchData(Class<T> formClass, String dataUUID) throws CreateAsFormException, SynergyApiCallException, UnsupportedFieldTypeException
    {
        AsForm asfData = synergyApiProvider.getAsfData(dataUUID);
        return createAsForm(formClass, asfData);
    }

    public <T extends AsForm>
    T
    createAsForm(Class<T> asFormClass, AsForm asfData) throws CreateAsFormException, UnsupportedFieldTypeException {
        try {
            T asFormObject = asFormClass.newInstance();
            Field[] allFields = asFormClass.getDeclaredFields();
            for (Field field : allFields) {
                Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
                for (Annotation annotation : declaredAnnotations) {
                    if (annotation instanceof TextInput) {
                        String cmpId = ((TextInput) annotation).value();
                        setFieldValue(asfData, asFormObject, field, cmpId, ComponentTypes.TEXT_INPUT);
                        break;
                    }
                    if (annotation instanceof NumericInput) {
                        String cmpId = ((NumericInput) annotation).value();
                        setFieldValue(asfData, asFormObject, field, cmpId, ComponentTypes.NUMERIC_INPUT);
                        break;
                    }
                    if (annotation instanceof Entity) {
                        String cmpId = ((Entity) annotation).value();
                        setFieldValue(asfData, asFormObject, field, cmpId, ComponentTypes.ENTITY);
                        break;
                    }
                    if (annotation instanceof ListBox) {
                        String cmpId = ((ListBox) annotation).value();
                        setFieldValue(asfData, asFormObject, field, cmpId, ComponentTypes.LISTBOX);
                        break;
                    }
                    if (annotation instanceof Table) {
                        String cmpId = ((Table) annotation).value();
                        if (field.getType().isAssignableFrom(AsFormData.class)) {
                            setFieldValue(asfData, asFormObject, field, cmpId, ComponentTypes.TABLE);
                        } else if (field.getType().isAssignableFrom(List.class)) {
                            getList(asfData, field.getGenericType(), cmpId, ComponentTypes.TABLE);
                        } else {
                            throw new UnsupportedFieldTypeException();
                        }

                        break;
                    }
                }
            }
            return asFormObject;
        } catch (InstantiationException e) {
            throw new CreateAsFormException("Form class should has accessible without params constructor");
        } catch (IllegalAccessException e) {
            throw new CreateAsFormException("Form class should be accessible");
        }
    }

    private void getList(AsForm asfData, Type genericType, String cmpId, String table) {

    }

    private <T extends AsForm>
    void
    setFieldValue(AsForm asfData, T asFormObject, Field field, String cmpId, String cmpType) throws IllegalAccessException, UnsupportedFieldTypeException {
        field.setAccessible(true);
        if (field.getType().isAssignableFrom(String.class)) {
            // string
            String value = getValueForClassField(field, asfData, cmpId);
            field.set(asFormObject, value);

        } if (field.getType().isAssignableFrom(Integer.class)) {
            // int
            String value = getValueForClassField(field, asfData, cmpId);
            field.set(asFormObject, Integer.parseInt(value));

        } if (field.getType().isAssignableFrom(Double.class)) {
            // double
            String value = getValueForClassField(field, asfData, cmpId);
            field.set(asFormObject, Double.parseDouble(value));

        } else if (field.getType().isAssignableFrom(AsFormData.class)) {
            // common type
            AsFormData data = asfData.getData(cmpId);
            if (data != null) {
                AsFormData fieldAsFormData = new AsFormData();
                fieldAsFormData.setId(cmpId);
                fieldAsFormData.setType(cmpType);
                fieldAsFormData.setValue(data.getValue());
                fieldAsFormData.setKey(data.getKey());
                fieldAsFormData.setKeys(data.getKeys());
                fieldAsFormData.setValues(data.getValues());
                fieldAsFormData.setUserID(data.getUserID());
                fieldAsFormData.setValueID(data.getValueID());
                fieldAsFormData.setLabel(data.getLabel());
                fieldAsFormData.setUsername(data.getUsername());
                fieldAsFormData.setData(data.getData());

                field.set(asFormObject, fieldAsFormData);
            }
        } else {
            throw new UnsupportedFieldTypeException("This type unsupported");
        }
    }

    private String getValueForClassField(Field field, AsForm asfData, String cmpId) {
        boolean fetchKey = false;
        Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
        for (Annotation annotation : declaredAnnotations) {
            if (annotation instanceof KeyValue) {
                fetchKey = true;
            }
        }
        if (fetchKey) {
            return asfData.getKey(cmpId);
        }
        return asfData.getValue(cmpId);
    }
}
