package kz.arta.synergy.asforms.pojo;

import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
public class AsForm {

    private String nodeUUID;
    private String uuid;
    private String form;
    private String modified;
    private List<AsFormData> data;

    public AsForm() {
    }

    public AsFormData getData(String cmpId) {
        if (getData() == null || getData().isEmpty()) {
            return null;
        }
        for (AsFormData asFormData : getData()) {
            if (asFormData.getId() != null && asFormData.getId().equalsIgnoreCase(cmpId)) {
                return asFormData;
            }
        }
        return null;
    }

    public String getValue(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    public String getKey(String cmpId) {
        AsFormData data = getData(cmpId);
        if (data != null) {
            return data.getKey();
        }
        return null;
    }

    public String getNodeUUID() {
        return nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getForm() {
        return form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getModified() {
        return modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public List<AsFormData> getData() {
        return data;
    }

    public void setData(List<AsFormData> data) {
        this.data = data;
    }
}
