package kz.arta.synergy.api.asforms.converter.components;

import kz.arta.synergy.api.asforms.AsfTableUtil;
import kz.arta.synergy.api.asforms.annotations.Table;
import kz.arta.synergy.api.asforms.converter.AsFormConverter;
import kz.arta.synergy.api.asforms.exceptions.UnsupportedFieldTypeException;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;
import kz.arta.synergy.api.asforms.pojo.ComponentTypes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author raimbek
 * @since 11.11.2016
 */
public class TableConverter extends AbstractComponentConverter {

    private AsFormConverter asFormConverter;

    public TableConverter(AsFormConverter asFormConverter) {
        this.asFormConverter = asFormConverter;
    }

    @Override
    public <T> AsFormData toAsfData(T asForm, Field field, Annotation annotation, String index) throws IllegalAccessException {
        Table tableAnnotation = (Table) annotation;
        if (field.getType().isAssignableFrom(AsFormData.class)) {
            AsFormData asFormData = AsFormData.create(tableAnnotation.id(), ComponentTypes.TABLE);
            AsFormData tableData = (AsFormData) field.get(asForm);
            if (tableData != null && tableData.getData() != null) {
                asFormData.setData(tableData.getData());
            }
            return asFormData;
        } else if (field.getType().isAssignableFrom(List.class)) {
            return listToAppendableTableAsfData(asForm, field, tableAnnotation.id());
        } else {
            throw new UnsupportedFieldTypeException();
        }
    }

    @Override
    public <T> void setFieldValue(AsFormDataContainer asfData, T asFormObject, Field field, Annotation annotation, String index) throws Exception {
        Table tableAnnotation = (Table) annotation;
        if (field.getType().isAssignableFrom(AsFormData.class)) {
            super.setFieldValue(asfData, asFormObject, field, tableAnnotation, index);
        } else if (field.getType().isAssignableFrom(List.class)) {
            List list = tableToList(asfData, tableAnnotation.type(), tableAnnotation.id());
            field.setAccessible(true);
            field.set(asFormObject, list);
        } else {
            throw new UnsupportedFieldTypeException();
        }
    }

    @Override
    public String getType(Annotation annotation) {
        return ComponentTypes.TABLE;
    }

    @Override
    public String getCmpId(Annotation annotation) {
        return ((Table) annotation).value();
    }

    private <T> AsFormData listToAppendableTableAsfData(T asForm, Field field, String id) throws IllegalAccessException {
        AsFormData tableData = AsFormData.create(id, ComponentTypes.TABLE);
        field.setAccessible(true);
        List tableList = (List) field.get(asForm);
        for (int bIndex = 1; bIndex <= tableList.size(); bIndex++) {
            AsFormDataContainer asFormDataContainer = asFormConverter.toAsfData(tableList.get(bIndex - 1), String.valueOf(bIndex));
            for (AsFormData asFormData : asFormDataContainer.getData()) {
                tableData.addData(asFormData);
            }
        }
        return tableData;
    }

    @SuppressWarnings("unchecked")
    private List tableToList(AsFormDataContainer asfData, Class genericType, String cmpId) {
        AsFormData tableData = asfData.getData(cmpId);
        if (tableData == null || tableData.getData() == null || tableData.getData().isEmpty()) {
            return null;
        }

        List table = new ArrayList<>();
        Set<String> indexes = AsfTableUtil.tableBIndexes(tableData);
        for (String index : indexes) {
            table.add(asFormConverter.toAsForm(genericType, tableData, index));
        }
        return table;
    }
}
