package kz.arta.synergy.api.services;

import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.services.storage.Attachment;
import kz.arta.synergy.api.services.storage.AttachmentList;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertNotNull;

/**
 * Created by: Abzal Kultayev
 * Date: 12.11.16
 * Time: 16:56
 */
public class StorageServiceTest {
    StorageService service = StorageService.newInstance(new QueryContext("http://192.168.3.233:8080/Synergy", "NppAdmin", "123456"));
    private String documentID = "05647530-a72f-11e6-bfd9-00163ebf20cd";
    @Test
    public void testStartUploadFile() throws Exception {
        String tempFileName = service.startUploadFile();
        assertNotNull(tempFileName);
    }

    @Test
    public void testCreateAttachment() throws Exception {
        String tempFileName = service.startUploadFile();
        String attachment = service.createAttachment(documentID, "FILENAME.PDF", tempFileName);
        assertEquals(attachment, "");
    }

    @Test
    public void testLastAttachments() throws Exception {
        AttachmentList attachmentList = service.getLastAttachments(documentID);
        assertNotNull(attachmentList);
    }

    @Test
    public void testCreateAndGetAttachment() throws Exception {
        String tempFileName = service.startUploadFile();
        Attachment attachment = service.createAndGetAttachment(documentID, "Filename.pdf", tempFileName);
        assertNotNull(attachment);
    }
}