package kz.arta.synergy.api.asforms;

import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * User: vsl
 * DateCmp: 3/18/15
 * Time: 9:48 AM
 *
 * Утилиты для работы с данными форм
 */
public class AsfTableUtil {
    private static final Pattern BLOCK_ID_PATTERN = Pattern.compile("(.*)-b([0-9]{1,})$");

    /**
     * Есть ли табличный индекс в id
     */
    public static boolean hasBIndex(String id) {
        return BLOCK_ID_PATTERN.matcher(id).matches();
    }

    /**
     * Возвращает табличный индекс из id, если его нет - null
     */
    public static String getBindex(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return null;
        } else {
            return matcher.group(2);
        }
    }

    /**
     * Возвращает часть id без табличного индекса если он есть,
     * если нет - просто возвращает id
     */
    public static String getBlockComponentId(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return id;
        } else {
            return matcher.group(1);
        }
    }

    /**
     * Возвращает табличный индекс из id, если его нет -1
     */
    public static int getIntBindex(String id) {
        String bIndex = getBindex(id);
        if (bIndex == null || bIndex.isEmpty()) {
            return -1;
        }

        try {
            return Integer.parseInt(bIndex);
        } catch (NumberFormatException e) {
            return -1;
        }
    }

    public static Set<String> tableBIndexes(AsFormDataContainer asFormDataContainer) {
        Set<String> indexes = new TreeSet<>();
        for (AsFormData data : asFormDataContainer.getData()) {
            if (data == null || data.getId() == null || data.getId().isEmpty()) {
                continue;
            }
            if (hasBIndex(data.getId())) {
                indexes.add(getBindex(data.getId()));
            }
        }
        return indexes;
    }
}
