package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyUser;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class PersonService {

    private final RestHttpQuery restHttpQuery;

    private PersonService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static PersonService newInstance(QueryContext queryContext) {
        return new PersonService(queryContext);
    }

    public SynergyUser getUser() throws IOException {
        String user = restHttpQuery.doQuery(Query.newInstance().url("/rest/api/person/auth"));
        return JsonUtils.read(user, SynergyUser.class);
    }
}
