package kz.arta.synergy.api.asforms;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.asforms.pojo.AsFormDefinition;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.net.URL;

/**
 * @author raimbek
 * @since 25.11.2016
 */
public class AsFormsServiceGetExtTest {


    @Test
    public void testGetFormDefinitionExt() throws Exception {
        URL url = Resources.getResource("data/form-ext.json");
        String formExtJson = Resources.toString(url, Charsets.UTF_8);

        RestHttpQuery restHttpQueryMock = Mockito.mock(RestHttpQuery.class);
        Mockito.when(restHttpQueryMock.doQuery(Mockito.any(Query.class))).thenReturn(formExtJson);
        AsFormService asFormService = AsFormService.newInstance(new QueryContext("localhost")).setRestHttpQuery(restHttpQueryMock);

        AsFormDefinition formDefinition = asFormService.getFormDefinitionExt(null, null, null);
        Assert.assertTrue(formDefinition.hasCmp("avtor"));
        Assert.assertFalse(formDefinition.hasCmp("not-cmp"));
    }
}
