package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.DocSend;
import kz.arta.synergy.api.pojo.DocumentInfo;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class DocflowService {

    private final RestHttpQuery restHttpQuery;

    private DocflowService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static DocflowService newInstance(QueryContext queryContext) {
        return new DocflowService(queryContext);
    }

    public DocumentInfo documentInfo(String documentId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/docflow/doc/document_info")
                .queryParam("documentID", documentId);
        return JsonUtils.read(restHttpQuery.doQuery(query), DocumentInfo.class);
    }

    public String createDocAttachment(String documentID, String fileName, String filePath) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .url("/rest/api/docflow/doc/attachment/create")
                .formParam("documentID", documentID)
                .formParam("fileName", fileName)
                .formParam("filePath", filePath);
        return restHttpQuery.doQuery(query);
    }

    public String docSend(DocSend docSend) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .url("/rest/api/docflow/doc/send")
                .header("Content-Type", "application/json;charset=utf-8")
                .body(JsonUtils.toJson(docSend));
        return restHttpQuery.doQuery(query);
    }
}
