package kz.arta.synergy.api.asforms.converter.components;

import kz.arta.synergy.api.asforms.annotations.NumericInput;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.ComponentTypes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * @author raimbek
 * @since 11.11.2016
 */
public class NumericInputConverter extends AbstractComponentConverter {

    @Override
    public <T> AsFormData toAsfData(T asForm, Field field, Annotation annotation, String index) throws IllegalAccessException {
        AsFormData asFormData = super.toAsfData(asForm, field, annotation, index);
        asFormData.setKey(String.valueOf(field.get(asForm)));
        return asFormData;
    }

    @Override
    public String getType(Annotation annotation) {
        return ComponentTypes.NUMERIC_INPUT;
    }

    @Override
    public String getCmpId(Annotation annotation) {
        return ((NumericInput) annotation).value();
    }
}
