package kz.arta.synergy.api.asforms.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author raimbek
 * @since 02.11.2016
 */
public class AdvancedSearchParams {
    private String query;
    private List<String> parameters = new ArrayList<String>();
    private boolean searchInRegistry = true;
    private int startRecord = 0;
    private int recordsCount = 100;
    private List<List<String>> dynParams = new ArrayList<List<String>>();

    public AdvancedSearchParams() {
    }

    public static AdvancedSearchParams build(String query, String... parameters) {
        AdvancedSearchParams advancedSearchParams = new AdvancedSearchParams();
        advancedSearchParams.setQuery(query);
        advancedSearchParams.setParameters(Arrays.asList(parameters));
        return advancedSearchParams;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<String> getParameters() {
        return parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public boolean isSearchInRegistry() {
        return searchInRegistry;
    }

    public void setSearchInRegistry(boolean searchInRegistry) {
        this.searchInRegistry = searchInRegistry;
    }

    public int getStartRecord() {
        return startRecord;
    }

    public void setStartRecord(int startRecord) {
        this.startRecord = startRecord;
    }

    public int getRecordsCount() {
        return recordsCount;
    }

    public void setRecordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
    }

    public List<List<String>> getDynParams() {
        return dynParams;
    }

    public void setDynParams(List<List<String>> dynParams) {
        this.dynParams = dynParams;
    }
}
