package kz.arta.synergy.api.asforms.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author raimbek
 * @since 25.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AsFormProperty {
    private String id;
    private String type;
    private String label;
    private Map<String, Object> config;
    private Map<String, String> style;
    private List<AsFormProperty> properties = new ArrayList<>();

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Map<String, Object> getConfig() {
        return config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    public Map<String, String> getStyle() {
        return style;
    }

    public void setStyle(Map<String, String> style) {
        this.style = style;
    }

    public List<AsFormProperty> getProperties() {
        return properties;
    }

    public void setProperties(List<AsFormProperty> properties) {
        this.properties = properties;
    }

    public boolean hasCmp(String id) {
        for (AsFormProperty property : properties) {
            if (property.getId().equals(id)) {
                return true;
            }
            if (property.hasCmp(id)) {
                return true;
            }
        }
        return false;
    }
}
