package kz.arta.synergy.api;

import org.testng.Assert;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author raimbek
 * @since 29.11.2016
 */
public class RestHttpQueryTest {

    @Test
    public void testJoinParamsForQuery() throws Exception {
        RestHttpQuery restHttpQuery = new RestHttpQuery(null);
        Map<String, Object> params = new HashMap<>();
        params.put("one", "value1");
        params.put("two", "value2");
        params.put("null_value", null);
        params.put("three", "кирилица с пробелом");

        String expected = "two=value2&one=value1&three=%D0%BA%D0%B8%D1%80%D0%B8%D0%BB%D0%B8%D1%86%D0%B0+%D1%81+%D0%BF%D1%80%D0%BE%D0%B1%D0%B5%D0%BB%D0%BE%D0%BC";

        String result = restHttpQuery.joinParamsForQuery(params);
        Assert.assertEquals(result, expected);
    }
}