package kz.arta.synergy.api.asforms.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.List;

/**
 * @author raimbek
 * @since 09.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AsFormData extends AsFormDataContainer {
    private String id;
    private String type;
    private String label;
    private String value;
    private String key;
    private String valueID;
    private String username;
    private String userID;
    private List<String> values;
    private List<String> keys;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public String getValue(String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public String getKey(String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValueID() {
        return valueID;
    }

    public void setValueID(String valueID) {
        this.valueID = valueID;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserID() {
        return userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public List<String> getValues() {
        return values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public List<String> getKeys() {
        return keys;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public static AsFormData textbox(String cmpId, String value) {
        AsFormData asFormData = create(cmpId, ComponentTypes.TEXT_BOX);
        asFormData.setValue(value);
        return asFormData;
    }

    public static AsFormData numericinput(String cmpId, String value, String key) {
        AsFormData asFormData = create(cmpId, ComponentTypes.NUMERIC_INPUT);
        asFormData.setValue(value);
        asFormData.setKey(key);
        return asFormData;
    }

    public static AsFormData createDate(String cmpId, String value, String key) {
        AsFormData asFormData = create(cmpId, ComponentTypes.DATE);
        asFormData.setValue(value);
        asFormData.setKey(key);
        return asFormData;
    }

    public static AsFormData create(String id, String type) {
        AsFormData asFormData = new AsFormData();
        asFormData.setId(id);
        asFormData.setType(type);
        return asFormData;
    }

    public static AsFormData createOnlyWithValue(String value) {
        AsFormData asFormData = new AsFormData();
        asFormData.setValue(value);
        return asFormData;
    }

    public static AsFormData createOnlyWithKey(String key) {
        AsFormData asFormData = new AsFormData();
        asFormData.setKey(key);
        return asFormData;
    }

    public static AsFormData createByValueAndKey(String key, String value) {
        AsFormData asFormData = new AsFormData();
        asFormData.setKey(key);
        asFormData.setValue(value);
        return asFormData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        AsFormData that = (AsFormData) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        if (label != null ? !label.equals(that.label) : that.label != null) return false;
        if (value != null ? !value.equals(that.value) : that.value != null) return false;
        if (key != null ? !key.equals(that.key) : that.key != null) return false;
        if (valueID != null ? !valueID.equals(that.valueID) : that.valueID != null) return false;
        if (username != null ? !username.equals(that.username) : that.username != null) return false;
        if (userID != null ? !userID.equals(that.userID) : that.userID != null) return false;
        if (values != null ? !values.equals(that.values) : that.values != null) return false;
        return !(keys != null ? !keys.equals(that.keys) : that.keys != null);

    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (label != null ? label.hashCode() : 0);
        result = 31 * result + (value != null ? value.hashCode() : 0);
        result = 31 * result + (key != null ? key.hashCode() : 0);
        result = 31 * result + (valueID != null ? valueID.hashCode() : 0);
        result = 31 * result + (username != null ? username.hashCode() : 0);
        result = 31 * result + (userID != null ? userID.hashCode() : 0);
        result = 31 * result + (values != null ? values.hashCode() : 0);
        result = 31 * result + (keys != null ? keys.hashCode() : 0);
        return result;
    }
}
