package kz.arta.synergy.api;

import java.util.HashMap;
import java.util.Map;

/**
 * @author raimbek
 * @since 10.11.2016
 */
public class Query {
    private String url;

    private Map<String, String> headers = new HashMap<>();

    private Map<String, String> queryParams = new HashMap<>();

    private Map<String, String> formParams = new HashMap<>();

    private String body;

    private String method = "GET";

    private Query() {

    }

    public static Query newInstance() {
        return new Query();
    }

    public Query url(String url) {
        this.url = url;
        return this;
    }

    public Query queryParam(String key, String value) {
        queryParams.put(key, value);
        return this;
    }

    public Query formParam(String key, String value) {
        formParams.put(key, value);
        return this;
    }

    public Query header(String key, String value) {
        headers.put(key, value);
        return this;
    }

    public Query body(String body) {
        this.body = body;
        return this;
    }

    public Query methodPost() {
        this.method = "POST";
        return this;
    }

    public Query methodGet() {
        this.method = "GET";
        return this;
    }

    public String getUrl() {
        return url;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public Map<String, String> getQueryParams() {
        return queryParams;
    }

    public Map<String, String> getFormParams() {
        return formParams;
    }

    public String getBody() {
        if (body == null) {
            return "";
        }
        return body;
    }

    public String getMethod() {
        return method;
    }
}
