package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.NotificationSend;

import java.io.IOException;
import java.util.Arrays;

/**
 * Created by: Abzal Kultayev
 * Date: 25.11.16
 * Time: 15:55
 *
 * Сервис для отправления нотификации
 */
public class NotificationService {
    private final RestHttpQuery restHttpQuery;

    private NotificationService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static NotificationService newInstance(QueryContext queryContext) {
        return new NotificationService(queryContext);
    }

    public String sendNotification(String header, String body, String... userIDs) throws IOException {
        NotificationSend notification = new NotificationSend();
        notification.setHeader(header);
        notification.setMessage(body);
        notification.setUsers(Arrays.asList(userIDs));
        return sendNotification(notification);
    }

    public String sendNotification(NotificationSend notification) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .header("Content-Type", "application/json; charset=utf-8")
                .url("/rest/api/notifications/send")
                .body(JsonUtils.toJson(notification));
        return restHttpQuery.doQuery(query);
    }
}
