### Пользовательские компоненты {#userModules}

*   [crm_component_canban_deal](#uMCanbanDeal)
*   [crm_component_deals_dashboard](#uMDealsDashboard)
*   [crm_component_deals_productivity](#uMDealsProductivity)
*   [crm_component_deal_button](#uMDealButton)
*   [crm_component_funnel](#uMFunnel)
*   [crm_component_funnel_deal](#uMFunnelDeal)
*   [crm_component_group_button](#uMGroupButton)
*   [crm_component_group_button_deal](#uMGroupButtonDeal)
*   [crm_component_leads_dashboard](#uMLeadsDashboard)
*   [crm_component_notifications](#uMNotifications)
*   [crm_component_registry_chooser](#uMRegistryChooser)

#### crm_component_canban {#uMCanban}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_canban                                     |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<div id="redips-drag">

</div>

```

JAVASCRIPT код:

``` xml

/*jslint white: true, browser: true, undef: true, nomen: true, eqeqeq: true, plusplus: false, bitwise: true, regexp: true, strict: true, newcap: true, immed: true, maxerr: 14 */
/*global window: false, REDIPS: true */

/* enable strict mode */
"use strict";

// define redips_init variable
var redipsInit;


// redips initialization
redipsInit = function () {
    // reference to the REDIPS.drag library and message line
    var	rd = REDIPS.drag;
    // how to display disabled elements
    rd.style.borderDisabled = 'solid';	// border style for disabled element will not be changed (default is dotted)
    rd.style.opacityDisabled = 60;		// disabled elements will have opacity effect
    REDIPS.drag.dropMode = 'multiple';
    // initialization
    rd.init();
    // only "smile" can be placed to the marked cell
    rd.mark.exception.d8 = 'smile';
    // prepare handlers
    rd.event.clicked = function () {
    };
    rd.event.dblClicked = function () {
    };
    rd.event.moved  = function () {
    };
    rd.event.notMoved = function () {
    };
    rd.event.dropped = function () {
        var pos = rd.getPosition();
        console.log($(rd.obj).attr('status'));
        var status = model.currentData[pos[2]];
        if ($(rd.obj).attr('status') === status.status) {
            return;
        }
        AS.SERVICES.showWaitWindow();
        var pFact = jQuery.ajax({
            url: window.location.origin + "/crm/rest/api/funnel/changeLeadStatus?statusID="+(status.status) + "&statusName="+(status.name)+"&leadID=" + rd.obj.id,
            type: "POST",
            beforeSend: AS.FORMS.ApiUtils.addAuthHeader,
            dataType: "text",
            error: function(jqXHR, textStatus, errorThrown){
                model.playerModel.redraw();
                AS.SERVICES.hideWaitWindow();
                try {
                    AS.SERVICES.showErrorMessage(jqXHR.responseText);
                } catch (e) {
                    console.log(e);
                }
            }
        });

        jQuery.when(pFact).then(function (data) {
            model.playerModel.firstShow = false;
            console.log(data);
            model.playerModel.redraw();
            var object = JSON.parse(data);
            if (object.dealObject) {
                var documentID = object.id;
                var hash = '#' + jQuery.param({
                        submodule: 'common',
                        action: 'open_document',
                        document_identifier: documentID});
                window.top.location.hash = hash;
            }
            AS.SERVICES.hideWaitWindow();
        });
    };
    rd.event.switched = function () {
    };
    rd.event.clonedEnd1 = function () {
    };
    rd.event.clonedEnd2 = function () {
    };
    rd.event.notCloned = function () {
    };
    rd.event.deleted = function (cloned) {
        // if cloned element is directly moved to the trash
        if (cloned) {
            // set id of original element (read from redips property)
            // var id_original = rd.obj.redips.id_original;
        }
        else {
        }
    };
    rd.event.undeleted = function () {
    };
    rd.event.cloned = function () {
    };
    rd.event.changed = function () {
        // get target and source position (method returns positions as array)
        var pos = rd.getPosition();
    };
};


// toggles trash_ask parameter defined at the top
function toggleConfirm(chk) {
    if (chk.checked === true) {
        REDIPS.drag.trash.question = 'Are you sure you want to delete DIV element?';
    }
    else {
        REDIPS.drag.trash.question = null;
    }
}


// toggles delete_cloned parameter defined at the top
function toggleDeleteCloned(chk) {
    REDIPS.drag.clone.drop = !chk.checked;
}


// enables / disables dragging
function toggleDragging(chk) {
    REDIPS.drag.enableDrag(chk.checked);
}


// function sets drop_option parameter defined at the top
function setMode(radioButton) {
    REDIPS.drag.dropMode = radioButton.value;
}


view.initDnd = redipsInit;

```

#### crm_component_canban_deal {#uMCanbanDeal}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_canban_deal                                |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<div id="redips-drag">

</div>

```

JAVASCRIPT код:

``` xml

/*jslint white: true, browser: true, undef: true, nomen: true, eqeqeq: true, plusplus: false, bitwise: true, regexp: true, strict: true, newcap: true, immed: true, maxerr: 14 */
/*global window: false, REDIPS: true */

/* enable strict mode */
"use strict";

// define redips_init variable
var redipsInit;


// redips initialization
redipsInit = function () {
    // reference to the REDIPS.drag library and message line
    var	rd = REDIPS.drag;
    // how to display disabled elements
    rd.style.borderDisabled = 'solid';	// border style for disabled element will not be changed (default is dotted)
    rd.style.opacityDisabled = 60;		// disabled elements will have opacity effect
    REDIPS.drag.dropMode = 'multiple';
    // initialization
    rd.init();
    // only "smile" can be placed to the marked cell
    rd.mark.exception.d8 = 'smile';
    // prepare handlers
    rd.event.clicked = function () {
    };
    rd.event.dblClicked = function () {
    };
    rd.event.moved  = function () {
    };
    rd.event.notMoved = function () {
    };
    rd.event.dropped = function () {
        var pos = rd.getPosition();
        console.log($(rd.obj).attr('status'));
        var status = model.currentData[pos[2]];
        if ($(rd.obj).attr('status') === status.status) {
            return;
        }
        AS.SERVICES.showWaitWindow();
        var pFact = jQuery.ajax({
            url: window.location.origin + "/crm/rest/api/funnel/changeDealStatus?statusID="+(status.status) + "&statusName="+(status.name)+"&leadID=" + rd.obj.id,
            type: "POST",
            beforeSend: AS.FORMS.ApiUtils.addAuthHeader,
            dataType: "text",
            error: function(jqXHR, textStatus, errorThrown){
                model.playerModel.redraw();
                AS.SERVICES.hideWaitWindow();
                try {
                    AS.SERVICES.showErrorMessage(jqXHR.responseText);
                } catch (e) {
                    console.log(e);
                }
            }
        });

        jQuery.when(pFact).then(function (data) {
            model.playerModel.firstShow = false;
            console.log(data);
            model.playerModel.redraw();
            var object = JSON.parse(data);
            if (object.dealObject) {
                var documentID = object.id;
                var hash = '#' + jQuery.param({
                        submodule: 'common',
                        action: 'open_document',
                        document_identifier: documentID});
                window.top.location.hash = hash;
            }
            AS.SERVICES.hideWaitWindow();
        });
    };
    rd.event.switched = function () {
    };
    rd.event.clonedEnd1 = function () {
    };
    rd.event.clonedEnd2 = function () {
    };
    rd.event.notCloned = function () {
    };
    rd.event.deleted = function (cloned) {
        // if cloned element is directly moved to the trash
        if (cloned) {
            // set id of original element (read from redips property)
            // var id_original = rd.obj.redips.id_original;
        }
        else {
        }
    };
    rd.event.undeleted = function () {
    };
    rd.event.cloned = function () {
    };
    rd.event.changed = function () {
        // get target and source position (method returns positions as array)
        var pos = rd.getPosition();
    };
};


// toggles trash_ask parameter defined at the top
function toggleConfirm(chk) {
    if (chk.checked === true) {
        REDIPS.drag.trash.question = 'Are you sure you want to delete DIV element?';
    }
    else {
        REDIPS.drag.trash.question = null;
    }
}


// toggles delete_cloned parameter defined at the top
function toggleDeleteCloned(chk) {
    REDIPS.drag.clone.drop = !chk.checked;
}


// enables / disables dragging
function toggleDragging(chk) {
    REDIPS.drag.enableDrag(chk.checked);
}


// function sets drop_option parameter defined at the top
function setMode(radioButton) {
    REDIPS.drag.dropMode = radioButton.value;
}


view.initDnd = redipsInit

```

#### crm_component_deals_dashboard {#uMDealsDashboard}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_deals_dashboard                            |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<iframe src="http://%IP_adress%:5601/app/kibana#/dashboard/%D0%A3%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5-%D0%BF%D1%80%D0%BE%D0%B4%D0%B0%D0%B6%D0%B0%D0%BC%D0%B8?embed=true&_g=(refreshInterval%3A('%24%24hashKey'%3A'object%3A36258'%2Cdisplay%3A'30%20seconds'%2Cpause%3A!f%2Csection%3A1%2Cvalue%3A30000)%2Ctime%3A(from%3Anow-15m%2Cmode%3Aquick%2Cto%3Anow))" height="100%" width="100%"></iframe>

```

#### crm_component_deals_productivity {#uMDealsProductivity}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_deals_productivity                         |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<iframe src="http://%IP_adress%:5601/app/kibana#/dashboard/%D0%9F%D1%80%D0%BE%D0%B4%D1%83%D0%BA%D1%82%D0%B8%D0%B2%D0%BD%D0%BE%D1%81%D1%82%D1%8C?embed=true&_g=(refreshInterval%3A('%24%24hashKey'%3A'object%3A700'%2Cdisplay%3A'30%20seconds'%2Cpause%3A!f%2Csection%3A1%2Cvalue%3A30000)%2Ctime%3A(from%3Anow-15m%2Cmode%3Aquick%2Cto%3Anow))" height="100%" width="100%"></iframe>

```

#### crm_component_deal_button {#uMDealButton}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_deal_button                                |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<button class="ns-approveButton ns-basicChooserApplyButton ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only" role="button" style="margin: 10px 0; display: block;" innerId='make_deal'>Создать</button>

```

JAVASCRIPT код:

``` xml

var button = jQuery(view.container).children("[innerId='make_deal']");
var locale = AS.OPTIONS.locale;
var statusValue;
model.playerModel.dictionaryCache.getDictionary('crm_dict_leadStatus', AS.OPTIONS.locale, function(dictionary) {
    if(dictionary !==  null) {
        dictionary.forEach(function(data, index){
            if (data['crm_dict_leadStatus_end'] === '1') {
                statusValue = data['crm_dict_leadStatus_value'];
                button.text(data['crm_dict_leadStatus_buttonName']);
            }
        });
    }
});
button.click(function(){
    model.playerModel.getModelWithId('crm_form_lead_deals_status').setValue(statusValue + '');
});

```

#### crm_component_funnel {#uMFunnel}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_funnel                                     |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<style>
.chart {
    margin: 0 auto;
    margin-top: 20px;
    margin-bottom: 20px;
    height: 500px;
    width: 450px;
}
</style
				<!-- Funnel container -->
				<div class="chart" id="funnel"></div>

```

JAVASCRIPT код:

``` xml

/* global D3Funnel */

const data = {
normal: [
   ['Первичная регистрация', [0, ''], '#e73a00'],
    ['Квалификация', [0, ''], '#fa6c00'],
    ['Взращивание', [0, ''], '#ffa900'],
    ['Подтверждение интереса', [0, ''], '#ffc500'],
    ['В сделку', [0, ''], '#a6cf00'],
]
};
const options = {

        chart: {
            width: 450,
            height: 500,
            bottomWidth: 1 / 2,
            curve: {
                enabled: false,
            },
        },
        block: {
            dynamicHeight: true,
            highlight: true,
            minHeight: 40,

        },
        label: {
            format: '{l}: {v}\n{f}',
        },
        events: {
            click: {
                block: (d) => {
                alert('<' + d.label.raw + '> selected.');
},
},
}
}

const chart = new D3Funnel('#funnel');
const picker = document.getElementById('picker');
chart.draw(data.normal, options);

```

#### crm_component_funnel_deal {#uMFunnelDeal}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_funnel_deal                                |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<style>
.chart {
    margin: 0 auto;
    margin-top: 20px;
    margin-bottom: 20px;
    height: 500px;
    width: 450px;
}
</style
				<!-- Funnel container -->
				<div class="chart" id="funnel"></div>

```

JAVASCRIPT код:

``` xml

/* global D3Funnel */

const data = {
normal: [
   ['Первичная регистрация', [0, ''], '#e73a00'],
    ['Квалификация', [0, ''], '#fa6c00'],
    ['Взращивание', [0, ''], '#ffa900'],
    ['Подтверждение интереса', [0, ''], '#ffc500'],
    ['В сделку', [0, ''], '#a6cf00'],
]
};
const options = {

        chart: {
            width: 450,
            height: 500,
            bottomWidth: 1 / 2,
            curve: {
                enabled: false,
            },
        },
        block: {
            dynamicHeight: false,
            highlight: true,
            minHeight: 40,

        },
        label: {
            format: '{l}: {v}\n{f}',
        },
        events: {
            click: {
                block: (d) => {
                alert('<' + d.label.raw + '> selected.');
},
},
}
}

const chart = new D3Funnel('#funnel');
const picker = document.getElementById('picker');
chart.draw(data.normal, options);

```

#### crm_component_group_button {#uMGroupButton}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_group_button                               |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml


<style>

 .btn_boot-group-lg > .btn_boot, .btn_boot-lg {
     padding: 10px 16px;
     font-size: 18px;
     border-radius: 6px
 }

.btn_boot-group-sm > .btn_boot, .btn_boot-sm {
    padding: 5px 10px;
    font-size: 12px;
    line-height: 1.5;
    border-radius: 3px
}

.btn_boot-group-xs > .btn_boot, .btn_boot-xs {
    padding: 1px 5px;
    font-size: 12px;
    line-height: 1.5;
    border-radius: 3px
}
.btn_boot-group, .btn_boot-group-vertical {
    position: relative;

    vertical-align: middle;
    padding-top: 3px;
}

.btn_boot-group-vertical > .btn_boot, .btn_boot-group > .btn_boot {
    position: relative;
    float: left
}

.btn_boot-group-vertical > .btn_boot.active, .btn_boot-group-vertical > .btn_boot:active, .btn_boot-group-vertical > .btn_boot:focus, .btn_boot-group-vertical > .btn_boot:hover, .btn_boot-group > .btn_boot.active, .btn_boot-group > .btn_boot:active, .btn_boot-group > .btn_boot:focus, .btn_boot-group > .btn_boot:hover {
    z-index: 2
}

.btn_boot-group .btn_boot + .btn_boot, .btn_boot-group .btn_boot + .btn_boot-group, .btn_boot-group .btn_boot-group + .btn_boot, .btn_boot-group .btn_boot-group + .btn_boot-group {
    margin-left: -1px
}

.btn_boot-toolbar {
    margin-left: -5px
}

.btn_boot-toolbar .btn_boot, .btn_boot-toolbar .btn_boot-group, .btn_boot-toolbar .input-group {
    float: left
}

.btn_boot-toolbar > .btn_boot, .btn_boot-toolbar > .btn_boot-group, .btn_boot-toolbar > .input-group {
    margin-left: 5px
}

.btn_boot-group > .btn_boot:not(:first-child):not(:last-child):not(.dropdown-toggle) {
    border-radius: 0
}

.btn_boot-group > .btn_boot:first-child {
    margin-left: 0
}

.btn_boot-group > .btn_boot:first-child:not(:last-child):not(.dropdown-toggle) {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0
}

.btn_boot-group > .btn_boot:last-child:not(:first-child), .btn_boot-group > .dropdown-toggle:not(:first-child) {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0
}

.btn_boot-group > .btn_boot-group {
    float: left
}

.btn_boot-group > .btn_boot-group:not(:first-child):not(:last-child) > .btn_boot {
    border-radius: 0
}

.btn_boot-group > .btn_boot-group:first-child:not(:last-child) > .btn_boot:last-child, .btn_boot-group > .btn_boot-group:first-child:not(:last-child) > .dropdown-toggle {
    border-top-right-radius: 0;
    border-bottom-right-radius: 0
}

.btn_boot-group > .btn_boot-group:last-child:not(:first-child) > .btn_boot:first-child {
    border-top-left-radius: 0;
    border-bottom-left-radius: 0
}

.btn_boot-group .dropdown-toggle:active, .btn_boot-group.open .dropdown-toggle {
    outline: 0
}

.btn_boot-group > .btn_boot + .dropdown-toggle {
    padding-right: 8px;
    padding-left: 8px
}

.btn_boot-group > .btn_boot-lg + .dropdown-toggle {
    padding-right: 12px;
    padding-left: 12px
}

.btn_boot-group.open .dropdown-toggle {
    -webkit-box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);
    box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125)
}

.btn_boot-group.open .dropdown-toggle.btn_boot-link {
    -webkit-box-shadow: none;
    box-shadow: none
}

.btn_boot .caret {
    margin-left: 0
}

.btn_boot-lg .caret {
    border-width: 5px 5px 0;
    border-bottom-width: 0
}

.dropup .btn_boot-lg .caret {
    border-width: 0 5px 5px
}

.btn_boot-group-vertical > .btn_boot, .btn_boot-group-vertical > .btn_boot-group, .btn_boot-group-vertical > .btn_boot-group > .btn_boot {
    display: block;
    float: none;
    width: 100%;
    max-width: 100%
}

.btn_boot-group-vertical > .btn_boot-group > .btn_boot {
    float: none
}

.btn_boot-group-vertical > .btn_boot + .btn_boot, .btn_boot-group-vertical > .btn_boot + .btn_boot-group, .btn_boot-group-vertical > .btn_boot-group + .btn_boot, .btn_boot-group-vertical > .btn_boot-group + .btn_boot-group {
    margin-top: -1px;
    margin-left: 0
}

.btn_boot-group-vertical > .btn_boot:not(:first-child):not(:last-child) {
    border-radius: 0
}

.btn_boot-group-vertical > .btn_boot:first-child:not(:last-child) {
    border-top-left-radius: 4px;
    border-top-right-radius: 4px;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 0
}

.btn_boot-group-vertical > .btn_boot:last-child:not(:first-child) {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-bottom-right-radius: 4px;
    border-bottom-left-radius: 4px
}

.btn_boot-group-vertical > .btn_boot-group:not(:first-child):not(:last-child) > .btn_boot {
    border-radius: 0
}

.btn_boot-group-vertical > .btn_boot-group:first-child:not(:last-child) > .btn_boot:last-child, .btn_boot-group-vertical > .btn_boot-group:first-child:not(:last-child) > .dropdown-toggle {
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 0
}

.btn_boot-group-vertical > .btn_boot-group:last-child:not(:first-child) > .btn_boot:first-child {
    border-top-left-radius: 0;
    border-top-right-radius: 0
}

.btn_boot-group-justified {
    display: table;
    width: 100%;
    table-layout: fixed;
    border-collapse: separate
}

.btn_boot-group-justified > .btn_boot, .btn_boot-group-justified > .btn_boot-group {
    display: table-cell;
    float: none;
    width: 1%
}

.btn_boot-group-justified > .btn_boot-group .btn_boot {
    width: 100%
}

.btn_boot-group-justified > .btn_boot-group .dropdown-menu {
    left: auto
}

.btn_boot {
    display: inline-block;
    padding: 6px 12px;
    margin-bottom: 0;
    font-size: 14px;
    font-weight: bolder;
    line-height: 0.9;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    -ms-touch-action: manipulation;
    touch-action: manipulation;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
    background-image: none;
    border: 1px solid transparent;
    border-radius: 4px;
}

.btn_boot.active.focus, .btn_boot.active:focus, .btn_boot.focus, .btn_boot:active.focus, .btn_boot:active:focus, .btn_boot:focus {

}

.btn_boot.focus, .btn_boot:focus, .btn_boot:hover {
    color: #333;
    text-decoration: none
}

.btn_boot.active, .btn_boot:active {
    background-image: none;
    outline: 0;
}

.btn_boot.disabled, .btn_boot[disabled], fieldset[disabled] .btn_boot {
    cursor: not-allowed;
    filter: alpha(opacity=65);
    -webkit-box-shadow: none;
    box-shadow: none;
    opacity: .65
}

a.btn_boot.disabled, fieldset[disabled] a.btn_boot {
    pointer-events: none
}

.btn_boot-default {
    color: #333;
    background-color: #eeeeee;
    border-color: #D5D5D5
}

.btn_boot-default.focus, .btn_boot-default:focus {
    color: #333;
    background-color: #eeeeee;
    border-color: #D5D5D5
}

.btn_boot-default:hover {
    color: #333;
    background-color: #eeeeee;
    border-color: #D5D5D5
}

.btn_boot-default.active, .btn_boot-default:active, .open > .dropdown-toggle.btn_boot-default {
    color: #333;
    background-color: #DDDDDD;
    border-color: #D5D5D5
}

.btn_boot-default.active.focus, .btn_boot-default.active:focus, .btn_boot-default.active:hover, .btn_boot-default:active.focus, .btn_boot-default:active:focus, .btn_boot-default:active:hover, .open > .dropdown-toggle.btn_boot-default.focus, .open > .dropdown-toggle.btn_boot-default:focus, .open > .dropdown-toggle.btn_boot-default:hover {
    color: #333;
    background-color: #DDDDDD;
    border-color: #D5D5D5
}

.btn_boot-default.active, .btn_boot-default:active, .open > .dropdown-toggle.btn_boot-default {
    background-image: none
}

.btn_boot-default.disabled.focus, .btn_boot-default.disabled:focus, .btn_boot-default.disabled:hover, .btn_boot-default[disabled].focus, .btn_boot-default[disabled]:focus, .btn_boot-default[disabled]:hover, fieldset[disabled] .btn_boot-default.focus, fieldset[disabled] .btn_boot-default:focus, fieldset[disabled] .btn_boot-default:hover {
    background-color: #fff;
    border-color: #D5D5D5
}

.btn_boot-default .badge {
    color: #fff;
    background-color: #8c8c8c
}
</style>
  <div class="btn_boot-group" style="
width:275px;
margin: 0 auto;
height: 26px;
align-self: center;
text-align: center;
" innerId="group">
<button type="button" class="btn_boot btn_boot-default" innerId="funnel">Воронка</button>
<button type="button" class="btn_boot btn_boot-default active" innerId="canban">Поток</button>
<button type="button" class="btn_boot btn_boot-default " innerId="dashboard">Аналитика</button>
</div>

```

JAVASCRIPT код:

``` xml

$(".btn_boot-group > .btn_boot").click(function(){
    $(this).addClass("active").siblings().removeClass("active");
});

var funnel = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='funnel']");
funnel.text(i18n.tr('Воронка'));
var canban = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='canban']");
canban.text(i18n.tr('Поток'));
var dashboard = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='dashboard']");
dashboard.text(i18n.tr('Аналитика'));
var funnel_cmp = view.playerView.getViewWithId('crm_form_funnel_funnel');
var canban_cmp = view.playerView.getViewWithId('crm_form_funnel_canban');
var bottom_cmp = view.playerView.getViewWithId('crm_form_funnel_bottom_sum');
var dashboard_cmp = view.playerView.getViewWithId('crm_form_funnel_dashboard');
var filterTable = view.playerView.getViewWithId('crm_form_funnel_filter_panel');
model.playerModel.funnelDrawn = false;
model.playerModel.canbanDrawn = false;
funnel.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(true);
    bottom_cmp.setVisible(true);
    canban_cmp.setVisible(false);
    dashboard_cmp.setVisible(false);
    model.playerModel.isFunnel = true;
    filterTable.setVisible(true);
    if (!model.playerModel.funnelDrawn) {
        model.playerModel.redraw();
    }
});
canban.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(false);
    canban_cmp.setVisible(true);
    bottom_cmp.setVisible(false);
    dashboard_cmp.setVisible(false);
    model.playerModel.isFunnel = false;
    filterTable.setVisible(true);
    if (!model.playerModel.canbanDrawn) {
        model.playerModel.redraw();
    }
});
dashboard.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(false);
    bottom_cmp.setVisible(false);
    canban_cmp.setVisible(false);
    dashboard_cmp.setVisible(true);
    dashboard_cmp.calcDim();
    filterTable.setVisible(false);
});

```

#### crm_component_group_button_deal {#uMGroupButtonDeal}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_group_button_deal                          |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml



<style>

    .btn_boot-group-lg > .btn_boot, .btn_boot-lg {
        padding: 10px 16px;
        font-size: 18px;
        border-radius: 6px
    }

    .btn_boot-group-sm > .btn_boot, .btn_boot-sm {
        padding: 5px 10px;
        font-size: 12px;
        line-height: 1.5;
        border-radius: 3px
    }

    .btn_boot-group-xs > .btn_boot, .btn_boot-xs {
        padding: 1px 5px;
        font-size: 12px;
        line-height: 1.5;
        border-radius: 3px
    }
    .btn_boot-group, .btn_boot-group-vertical {
        position: relative;

        vertical-align: middle;
        padding-top: 3px;
    }

    .btn_boot-group-vertical > .btn_boot, .btn_boot-group > .btn_boot {
        position: relative;
        float: left
    }

    .btn_boot-group-vertical > .btn_boot.active, .btn_boot-group-vertical > .btn_boot:active, .btn_boot-group-vertical > .btn_boot:focus, .btn_boot-group-vertical > .btn_boot:hover, .btn_boot-group > .btn_boot.active, .btn_boot-group > .btn_boot:active, .btn_boot-group > .btn_boot:focus, .btn_boot-group > .btn_boot:hover {
        z-index: 2
    }

    .btn_boot-group .btn_boot + .btn_boot, .btn_boot-group .btn_boot + .btn_boot-group, .btn_boot-group .btn_boot-group + .btn_boot, .btn_boot-group .btn_boot-group + .btn_boot-group {
        margin-left: -1px
    }

    .btn_boot-toolbar {
        margin-left: -5px
    }

    .btn_boot-toolbar .btn_boot, .btn_boot-toolbar .btn_boot-group, .btn_boot-toolbar .input-group {
        float: left
    }

    .btn_boot-toolbar > .btn_boot, .btn_boot-toolbar > .btn_boot-group, .btn_boot-toolbar > .input-group {
        margin-left: 5px
    }

    .btn_boot-group > .btn_boot:not(:first-child):not(:last-child):not(.dropdown-toggle) {
        border-radius: 0
    }

    .btn_boot-group > .btn_boot:first-child {
        margin-left: 0
    }

    .btn_boot-group > .btn_boot:first-child:not(:last-child):not(.dropdown-toggle) {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0
    }

    .btn_boot-group > .btn_boot:last-child:not(:first-child), .btn_boot-group > .dropdown-toggle:not(:first-child) {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0
    }

    .btn_boot-group > .btn_boot-group {
        float: left
    }

    .btn_boot-group > .btn_boot-group:not(:first-child):not(:last-child) > .btn_boot {
        border-radius: 0
    }

    .btn_boot-group > .btn_boot-group:first-child:not(:last-child) > .btn_boot:last-child, .btn_boot-group > .btn_boot-group:first-child:not(:last-child) > .dropdown-toggle {
        border-top-right-radius: 0;
        border-bottom-right-radius: 0
    }

    .btn_boot-group > .btn_boot-group:last-child:not(:first-child) > .btn_boot:first-child {
        border-top-left-radius: 0;
        border-bottom-left-radius: 0
    }

    .btn_boot-group .dropdown-toggle:active, .btn_boot-group.open .dropdown-toggle {
        outline: 0
    }

    .btn_boot-group > .btn_boot + .dropdown-toggle {
        padding-right: 8px;
        padding-left: 8px
    }

    .btn_boot-group > .btn_boot-lg + .dropdown-toggle {
        padding-right: 12px;
        padding-left: 12px
    }

    .btn_boot-group.open .dropdown-toggle {
        -webkit-box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125);
        box-shadow: inset 0 3px 5px rgba(0, 0, 0, .125)
    }

    .btn_boot-group.open .dropdown-toggle.btn_boot-link {
        -webkit-box-shadow: none;
        box-shadow: none
    }

    .btn_boot .caret {
        margin-left: 0
    }

    .btn_boot-lg .caret {
        border-width: 5px 5px 0;
        border-bottom-width: 0
    }

    .dropup .btn_boot-lg .caret {
        border-width: 0 5px 5px
    }

    .btn_boot-group-vertical > .btn_boot, .btn_boot-group-vertical > .btn_boot-group, .btn_boot-group-vertical > .btn_boot-group > .btn_boot {
        display: block;
        float: none;
        width: 100%;
        max-width: 100%
    }

    .btn_boot-group-vertical > .btn_boot-group > .btn_boot {
        float: none
    }

    .btn_boot-group-vertical > .btn_boot + .btn_boot, .btn_boot-group-vertical > .btn_boot + .btn_boot-group, .btn_boot-group-vertical > .btn_boot-group + .btn_boot, .btn_boot-group-vertical > .btn_boot-group + .btn_boot-group {
        margin-top: -1px;
        margin-left: 0
    }

    .btn_boot-group-vertical > .btn_boot:not(:first-child):not(:last-child) {
        border-radius: 0
    }

    .btn_boot-group-vertical > .btn_boot:first-child:not(:last-child) {
        border-top-left-radius: 4px;
        border-top-right-radius: 4px;
        border-bottom-right-radius: 0;
        border-bottom-left-radius: 0
    }

    .btn_boot-group-vertical > .btn_boot:last-child:not(:first-child) {
        border-top-left-radius: 0;
        border-top-right-radius: 0;
        border-bottom-right-radius: 4px;
        border-bottom-left-radius: 4px
    }

    .btn_boot-group-vertical > .btn_boot-group:not(:first-child):not(:last-child) > .btn_boot {
        border-radius: 0
    }

    .btn_boot-group-vertical > .btn_boot-group:first-child:not(:last-child) > .btn_boot:last-child, .btn_boot-group-vertical > .btn_boot-group:first-child:not(:last-child) > .dropdown-toggle {
        border-bottom-right-radius: 0;
        border-bottom-left-radius: 0
    }

    .btn_boot-group-vertical > .btn_boot-group:last-child:not(:first-child) > .btn_boot:first-child {
        border-top-left-radius: 0;
        border-top-right-radius: 0
    }

    .btn_boot-group-justified {
        display: table;
        width: 100%;
        table-layout: fixed;
        border-collapse: separate
    }

    .btn_boot-group-justified > .btn_boot, .btn_boot-group-justified > .btn_boot-group {
        display: table-cell;
        float: none;
        width: 1%
    }

    .btn_boot-group-justified > .btn_boot-group .btn_boot {
        width: 100%
    }

    .btn_boot-group-justified > .btn_boot-group .dropdown-menu {
        left: auto
    }

    .btn_boot {
        display: inline-block;
        padding: 6px 12px;
        margin-bottom: 0;
        font-size: 14px;
        font-weight: bolder;
        line-height: 0.9;
        text-align: center;
        white-space: nowrap;
        vertical-align: middle;
        -ms-touch-action: manipulation;
        touch-action: manipulation;
        cursor: pointer;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        background-image: none;
        border: 1px solid transparent;
        border-radius: 4px;
    }

    .btn_boot.active.focus, .btn_boot.active:focus, .btn_boot.focus, .btn_boot:active.focus, .btn_boot:active:focus, .btn_boot:focus {

    }

    .btn_boot.focus, .btn_boot:focus, .btn_boot:hover {
        color: #333;
        text-decoration: none
    }

    .btn_boot.active, .btn_boot:active {
        background-image: none;
        outline: 0;
    }

    .btn_boot.disabled, .btn_boot[disabled], fieldset[disabled] .btn_boot {
        cursor: not-allowed;
        filter: alpha(opacity=65);
        -webkit-box-shadow: none;
        box-shadow: none;
        opacity: .65
    }

    a.btn_boot.disabled, fieldset[disabled] a.btn_boot {
        pointer-events: none
    }

    .btn_boot-default {
        color: #333;
        background-color: #eeeeee;
        border-color: #D5D5D5
    }

    .btn_boot-default.focus, .btn_boot-default:focus {
        color: #333;
        background-color: #eeeeee;
        border-color: #D5D5D5
    }

    .btn_boot-default:hover {
        color: #333;
        background-color: #eeeeee;
        border-color: #D5D5D5
    }

    .btn_boot-default.active, .btn_boot-default:active, .open > .dropdown-toggle.btn_boot-default {
        color: #333;
        background-color: #DDDDDD;
        border-color: #D5D5D5
    }

    .btn_boot-default.active.focus, .btn_boot-default.active:focus, .btn_boot-default.active:hover, .btn_boot-default:active.focus, .btn_boot-default:active:focus, .btn_boot-default:active:hover, .open > .dropdown-toggle.btn_boot-default.focus, .open > .dropdown-toggle.btn_boot-default:focus, .open > .dropdown-toggle.btn_boot-default:hover {
        color: #333;
        background-color: #DDDDDD;
        border-color: #D5D5D5
    }

    .btn_boot-default.active, .btn_boot-default:active, .open > .dropdown-toggle.btn_boot-default {
        background-image: none
    }

    .btn_boot-default.disabled.focus, .btn_boot-default.disabled:focus, .btn_boot-default.disabled:hover, .btn_boot-default[disabled].focus, .btn_boot-default[disabled]:focus, .btn_boot-default[disabled]:hover, fieldset[disabled] .btn_boot-default.focus, fieldset[disabled] .btn_boot-default:focus, fieldset[disabled] .btn_boot-default:hover {
        background-color: #fff;
        border-color: #D5D5D5
    }

    .btn_boot-default .badge {
        color: #fff;
        background-color: #8c8c8c
    }
</style>
<div class="btn_boot-group" style=" width:400px; margin: 0 auto; height: 26px; align-self: center; text-align: center;" innerId="group">
    <button type="button" class="btn_boot btn_boot-default" innerId="funnel">Воронка</button>
    <button type="button" class="btn_boot btn_boot-default active" innerId="canban">Поток</button>
    <button type="button" class="btn_boot btn_boot-default " innerId="dashboard">Аналитика</button>
    <button type="button" class="btn_boot btn_boot-default " innerId="productivity">Продуктивность</button>
</div>

```

JAVASCRIPT код:

``` xml

$(".btn_boot-group > .btn_boot").click(function(){
    $(this).addClass("active").siblings().removeClass("active");
});

var funnel = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='funnel']");
funnel.text(i18n.tr('Воронка'));
var canban = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='canban']");
canban.text(i18n.tr('Поток'));
var dashboard = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='dashboard']");
dashboard.text(i18n.tr('Аналитика'));
var productivity = jQuery(view.container[0]).children("[innerId='group']").children("[innerId='productivity']");
productivity.text(i18n.tr('Продуктивность'));
var funnel_cmp = view.playerView.getViewWithId('crm_form_funnel_funnel');
var canban_cmp = view.playerView.getViewWithId('crm_form_funnel_canban');
var bottom_cmp = view.playerView.getViewWithId('crm_form_funnel_bottom_sum');
var dashboard_cmp = view.playerView.getViewWithId('crm_form_funnel_dashboard');
var productivity_cmp = view.playerView.getViewWithId('crm_form_funnel_productivity');
var filterTable = view.playerView.getViewWithId('crm_form_funnel_filter_panel');
model.playerModel.funnelDrawn = false;
model.playerModel.canbanDrawn = false;
funnel.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(true);
    bottom_cmp.setVisible(true);
    canban_cmp.setVisible(false);
    productivity_cmp.setVisible(false);
    dashboard_cmp.setVisible(false);
    model.playerModel.isFunnel = true;
    filterTable.setVisible(true);
    if (!model.playerModel.funnelDrawn) {
        model.playerModel.redraw();
    }
});
canban.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(false);
    canban_cmp.setVisible(true);
    bottom_cmp.setVisible(false);
    productivity_cmp.setVisible(false);
    dashboard_cmp.setVisible(false);
    model.playerModel.isFunnel = false;
    filterTable.setVisible(true);
    if (!model.playerModel.canbanDrawn) {
        model.playerModel.redraw();
    }
});
dashboard.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(false);
    bottom_cmp.setVisible(false);
    canban_cmp.setVisible(false);
    productivity_cmp.setVisible(false);
    dashboard_cmp.setVisible(true);
    dashboard_cmp.calcDim();
    filterTable.setVisible(false);
});

productivity.click(function(){
    $('body').css('overflow', 'auto');
    funnel_cmp.setVisible(false);
    bottom_cmp.setVisible(false);
    canban_cmp.setVisible(false);
    dashboard_cmp.setVisible(false);
    productivity_cmp.setVisible(true);
    productivity_cmp.calcDim();
    filterTable.setVisible(false);
});

```

#### crm_component_leads_dashboard {#uMLeadsDashboard}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_leads_dashboard                            |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<iframe src="http://%IP_adress%:5601/app/kibana#/dashboard/%D0%A3%D0%BF%D1%80%D0%B0%D0%B2%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5-%D0%BC%D0%B0%D1%80%D0%BA%D0%B5%D1%82%D0%B8%D0%BD%D0%B3%D0%BE%D0%BC?embed=true&_g=(refreshInterval%3A('%24%24hashKey'%3A'object%3A36258'%2Cdisplay%3A'30%20seconds'%2Cpause%3A!f%2Csection%3A1%2Cvalue%3A30000)%2Ctime%3A(from%3Anow-15m%2Cmode%3Aquick%2Cto%3Anow))" height="100%" width="100%"></iframe>

```

#### crm_component_notifications {#uMNotifications}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_notifications                              |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | выключен                                                 |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<style>
    .save_button_container {
        text-align: center;
        padding-top: 21px;
        padding-bottom: 21px;
    }

    .notification-container {
        width: 300px;
        position: absolute;
        bottom: 40px;
        right: 15px;
    }

    .notification {
        padding: 12px;
        text-overflow: ellipsis;
        white-space: nowrap;
        width: 275px;
        background-color: #ffffff;
        border-radius: 5px;
        box-shadow: 0px 0px 20px 0px rgba(0, 0, 0, 0.75);
        margin-top: 10px;

        color: #606060;
        font-size: 14px;
    }

    .info_block {
        display: flex;
    }

    .link_block {
        padding: 15px 0 15px 0;
        width: 270px;
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
    }

    .button_success {
        display: inline-block;
        background-color: #49b785;
        color: #ffffff;
        height: 32px;
        min-width: 32px;
        padding-left: 30px;
        padding-right: 30px;
        -moz-padding-end: 25px;
        -moz-padding-start: 25px;
        border: none;
        border-radius: 4px;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        font-size: 14px;
        font-weight: bold;
        margin-left: 25px;
    }

    .button_remain {
        display: inline-block;
        background-color: #ffffff;
        color: #606060;
        height: 32px;
        min-width: 32px;
        padding-left: 30px;
        padding-right: 30px;
        -moz-padding-end: 25px;
        -moz-padding-start: 25px;
        border-radius: 4px;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        font-size: 14px;
        font-weight: bold;
        border: 1px solid #e2e2e2;
    }

    .notification.more-notifications {
        padding: 6px 9px 6px 15px;
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
    }

    .comment_block {
        width: 250px;
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
        opacity: 0.5;
    }

    .link_block a {
        font-weight: bold;
        color: #606060;
        font-size: 14px;
    }

    .ring_block {
        padding-right: 9px;
    }
</style>

```

JAVASCRIPT код:

``` xml

var synergyURL = window.location.protocol + "//" + window.location.host + "/Synergy/";
AS.OPTIONS.coreUrl = synergyURL;

var putItem = setInterval(function () {
    var element = jQuery('.popupMenuBlack.popupMenuItemLeftBlack.createButton table.popupMenuItemBlack > tbody > tr:last');
    var elementLength = jQuery('.popupMenuBlack.popupMenuItemLeftBlack.createButton table.popupMenuItemBlack > tbody').length;
    var el2 = jQuery('.popupMenuBlack.popupMenuItemLeftBlack.createButton table.popupMenuItemBlack > tbody > tr:last [title="Напоминание"]');
    var menuHeight = jQuery('.popupMenuBlack.popupMenuItemLeftBlack.createButton table.popupMenuItemBlack').parent();
    if (elementLength == 1 && el2.length == 0) {
        element.after('<tr><td><table onmouseover="mouseOver(this)" onmouseout="mouseOut(this)" cellpadding="0" cellspacing="0" border="0" style="width: 100%; height: 24px;"><colgroup><col></colgroup><tbody><tr><td width="24px" class=""><img src="images/empty.gif" class="gwt-Image" style="width: 24px; height: 24px;"></td><td title="Напоминание" class="popup-menu-text" onclick="onItemClick()">Напоминание</td></tr></tbody></table></td></tr>')
        menuHeight.height(menuHeight.height() + 30);
    }
}, 100);

var onItemClick = function () {

    var container = jQuery('<div></div>', {id: 'form_player_container'});
    container.append(jQuery('<div></div>', {id: 'form_player_div'}));
    var buttonContainer = jQuery('<div></div>', {class: 'save_button_container'});
    var button = jQuery('<button id="save_button_task" class="button button-success" disabled>' + i18n.tr("Сохранить") + '</button>');
    buttonContainer.append(button);
    container.append(buttonContainer);

    var dialog = container.dialog({
        modal: true,
        width: 600,
        resizable: false,
        close: function (event, ui) {
            dialog.dialog('destroy').remove();
        },
        title: i18n.tr("Создание напоминания")
    });
    button.click(function () {
        var data = getData();
        if(!data){
            return;
        }
        saveTask(data, function (result) {
            notShowed.push({
                taskID: JSON.parse(result).taskID,
                taskObject: getTaskObjectArray(data.task),
                start: data.start,
                finish: data.finish,
                task: data.task
            });
            dialog.dialog('destroy').remove();
        });
    });
    jQuery('.popupMenuItemLeftBlack').hide();
    portal.createPlayer();
};

function getData() {
    var dict = portal.player.model.getModelWithId('dict').getTextValue();
    var task = portal.player.model.getModelWithId('comment').getValue();
    if (!task || task == 'null') {
        task = '';
    }
    var start = portal.player.model.getModelWithId('start').getValue();

    var lead = portal.player.model.getModelWithId('lead');
    var leadId = '';
    var leadName = '';
    if (lead) {
        leadId = lead.getValue();
        leadName = lead.getTextValue();
    }

    var deal = portal.player.model.getModelWithId('deal');
    var dealId = '';
    var dealName = '';
    if (deal) {
        dealId = deal.getValue();
        dealName = deal.getTextValue();
    }

    if(!dealId && !leadId){
        portal.player.view.getViewWithId('lead').markInvalid();
        portal.player.view.getViewWithId('deal').markInvalid();        
        AS.SERVICES.showErrorMessage(i18n.tr("Выберите лида или сделку"));
        return;
    }

    var breakChar = String.fromCharCode(13);

    var result = 'Напоминание!' + breakChar +
            dict + breakChar +
            leadName + breakChar +
            '#submodule=common&action=open_document&document_identifier=' + leadId + breakChar +
            dealName + breakChar +
            '#submodule=common&action=open_document&document_identifier=' + dealId + breakChar +
            breakChar +
            task;

    return {
        task: result,
        start: start,
        finish: start.substr(0, start.indexOf(' ')) + " 23:59:00"
    };
}

var mouseOver = function (element) {
    element.style.backgroundColor = '#E4EEF5';
};

var mouseOut = function (element) {
    element.style.backgroundColor = '';
};

var portal = {
    player: null,
    clearPlayer: function () {
        if (portal.player) {
            portal.player.destroy();
        }
        jQuery("#save_button_task").attr('disabled');
        portal.player = null;
    },
    /**
     * добавить новый проигрыватель форм
     */
    createPlayer: function (dataId) {
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        portal.player.model.on(AS.FORMS.EVENT_TYPE.valueChange, function (event, model, view) {
            var start = portal.player.model.getModelWithId('start');
            if (!start) {
                return;
            }

            var startValue = start.getValue();
            if (startValue) {
                jQuery("#save_button_task").removeAttr('disabled', 'disabled');
            } else {
                jQuery("#save_button_task").attr('disabled', 'disabled');
            }
        });

        portal.player.view.setEditable(true);

        AS.SERVICES.showWaitWindow();

        var handler = function (definition, data) {
            portal.player.model.buildModelsDefinition(definition, null);

            AS.SERVICES.hideWaitWindow();

            if (data) {
                portal.player.model.setAsfData(data);
            }
        };

        jQuery.when(loadDefaultAsfData("crm_form_task"))
                .then(function (data) {
                    jQuery.when(loadFormDefinition("crm_form_task", 0), data).then(handler);
                });


        portal.player.view.appendTo($('#form_player_div'));
    }
};

function loadDefaultAsfData(formCode) {
    return AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/asforms/getDefaultContent?formCode=' + formCode);
}

function loadFormDefinition(code, version) {
    if (version) {
        return AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/asforms/form_ext?formCode=' + code + "&version=" + version);
    } else {
        return AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/asforms/form_ext?formCode=' + code);
    }
}

function loadTasks(handler) {
    var currentDate = $.datepicker.formatDate('yy-mm-dd', new Date());
    var finish = new Date();
    finish.setDate(finish.getDate() + 7);
    var finishDate = $.datepicker.formatDate('yy-mm-dd', finish);
    return AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/diary/tasks/' + AS.OPTIONS.currentUser.userId + '/all?start=' + currentDate + '&finish=' + finishDate, handler);
}

function completeTask(taskID) {
    return AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/diary/tasks/complete?taskID=' + taskID);
}

function remainLater(data, handler) {
    return saveTask(data);
}

function saveTask(data, handler) {
    return AS.FORMS.ApiUtils.simpleAsyncPost('rest/api/diary/tasks/' + AS.OPTIONS.currentUser.userId + '/save',
            AS.FORMS.ApiUtils.getHandler(handler, true), "text", data, undefined, function () {
            });
}

function createNotification(taskObject, taskID) {

    var remain = jQuery('<button class="button_remain" taskID="' + taskID + '">' + i18n.tr("Отложить") + '</button>');
    var close = jQuery('<button class="button_success" taskID="' + taskID + '">' + i18n.tr("Закрыть") + '</button>');
    close.click(function (event) {
        var button = jQuery(event.target);
        var taskID = button.attr('taskID');
        completeTask(taskID);
        for (var i = 0; i < showed.length; i++) {
            if (showed[i].taskID === taskID) {
                showed.splice(i, 1);
                break;
            }
        }
        showNotify();
    });

    remain.click(function (event) {
        var button = jQuery(event.target);
        var taskID = button.attr('taskID');
        for (var i = 0; i < showed.length; i++) {
            if (showed[i].taskID === taskID) {
                var element = showed[i];
                var now = new Date();
                now.setMinutes(now.getMinutes() + 15);
                element.start = AS.FORMS.DateUtils.formatDate(now, '${yyyy}-${mm}-${dd} ${HH}:${MM}:${SS}');

                if (new Date(element.finish).getTime() < new Date(element.start).getTime()) {
                    now = new Date(element.finish);
                    now.setMinutes(now.getMinutes() + 15);
                    element.finish = AS.FORMS.DateUtils.formatDate(now, '${yyyy}-${mm}-${dd} ${HH}:${MM}:${SS}');
                }
                remainLater(element);
                notShowed.push(element);
                showed.splice(i, 1);
                break;
            }
        }
        showNotify();
    });

    var buttonBlock = jQuery('<div></div>', {class: 'button_block'});
    buttonBlock.append(remain);
    buttonBlock.append(close);

    var infoBlock = jQuery('<div></div>', {class: 'info_block'});
    var ring = jQuery('<div class="ring_block"><img src="data:image/jpeg;base64, ' + ringBase64 + '"/></div>');
    infoBlock.append(ring);

    var textInfo = jQuery('<div></div>', {class: 'text_info'});
    var dictValue = jQuery('<div title="' + _.escape(taskObject[1]) + '" class="dict_block">' + taskObject[1] + '</div>');
    textInfo.append(dictValue);
    var comment = jQuery('<div title="' + _.escape(taskObject[7]) + '" class="comment_block">' + taskObject[7] + '</div>');
    textInfo.append(comment);
    infoBlock.append(textInfo);

    var linkBlock = jQuery('<div class="link_block"><a title="' + _.escape(taskObject[2]) + '" href="' + taskObject[3] + '">' + taskObject[2] + '</a></div>');
    var linkDealBlock = jQuery('<div class="link_block"><a title="' + _.escape(taskObject[4]) + '" href="' + taskObject[5] + '">' + taskObject[4] + '</a></div>');

    var element = jQuery("<div class='notification'></div>");

    element.append(infoBlock);
    if (taskObject[2]) {
        element.append(linkBlock);
    }
    if (taskObject[4]) {
        element.append(linkDealBlock);
    }
    element.append(buttonBlock);
    return element;
}

/**
 * Проверка не наступило ли время уведомления
 */
function checkTimeInArray() {
    setInterval(function () {
        var tmp = [];
        var addedNotify = false;
        notShowed.forEach(function (task) {
            var object = {
                taskID: task.taskID,
                taskObject: task.taskObject,
                start: task.start,
                task: task.task,
                finish: task.finish
            };
            if (isTimeToShow(task.start)) {
                showed.push(object);
                addedNotify = true;
            } else {
                tmp.push(object);
            }
        });
        notShowed = tmp;
        if (addedNotify) {
            showNotify();
        }
    }, 1000);
}

/**
 * Отображение уведомлений, берет массив уведомлений которые необходимо показать и отображает их
 */
function showNotify() {
    clearAllNotifications();
    var tmp = 0;
    var more = 0;
    for (var i = showed.length - 1; i >= 0; i--) {
        var task = showed[i];
        if (tmp < 3) {
            notificationPanel.append(createNotification(task.taskObject, task.taskID));
        } else {
            more++;
        }
        tmp++;
    }
    if (more > 0) {
        notificationPanel.append(jQuery('<div class="notification more-notifications">' + i18n.tr("Еще напоминаний:") + ' ' + more + '</div>'));
    }
}

/**
 * Наступило ли время для показа уведомления
 */
function isTimeToShow(start) {
    return new Date().getTime() > new Date(start).getTime();
}

/**
 * Отчистка всех уведомлений
 */
function clearAllNotifications() {
    jQuery('.notification').remove();
}

/**
 * Создана ли заметка через нужную форму
 */
function isValidTask(taskObject) {
    return taskObject[0] == 'Напоминание!' && taskObject.length == 8;
}

/**
 * Получение массива объектов (разделены переносами)
 */
function getTaskObjectArray(task) {
    return task.split(String.fromCharCode(13));
}
/**
 * Вставка панели уведомлений
 */
jQuery(document).ready(function () {
    var checkExist = setInterval(function () {
        if (AS.OPTIONS.login && AS.OPTIONS.login != '') {
            addPanel();
            clearInterval(checkExist);
        }
    }, 100);
});

var notificationPanel = jQuery("<div class='notification-container'></div>");
var showed = [];
var notShowed = [];
var loaded = false;
function addPanel() {
    if (!loaded) {
        loaded = true;
        jQuery("body").append(notificationPanel);
        notificationPanel.show(function () {
            loadTasks(function (data) {
                clearAllNotifications();
                data.forEach(function (task) {
                    var taskObject = getTaskObjectArray(task.task);
                    if (isValidTask(taskObject)) {
                        var object = {
                            taskID: task.taskID,
                            taskObject: taskObject,
                            start: task.start,
                            task: task.task,
                            finish: task.finish
                        };
                        if (isTimeToShow(task.start)) {
                            showed.push(object);
                        } else {
                            notShowed.push(object);
                        }
                    }
                });
                checkTimeInArray();
                showNotify();
            });
        });
    }
}

//Иконка колокольчика
var ringBase64 = 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAQAAABKfvVzAAAACXBIWXMAAAsTAAALEwEAmpwYAAADGGlDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjaY2BgnuDo4uTKJMDAUFBUUuQe5BgZERmlwH6egY2BmYGBgYGBITG5uMAxIMCHgYGBIS8/L5UBFTAyMHy7xsDIwMDAcFnX0cXJlYE0wJpcUFTCwMBwgIGBwSgltTiZgYHhCwMDQ3p5SUEJAwNjDAMDg0hSdkEJAwNjAQMDg0h2SJAzAwNjCwMDE09JakUJAwMDg3N+QWVRZnpGiYKhpaWlgmNKflKqQnBlcUlqbrGCZ15yflFBflFiSWoKAwMD1A4GBgYGXpf8EgX3xMw8BSMDVQYqg4jIKAUICxE+CDEESC4tKoMHJQODAIMCgwGDA0MAQyJDPcMChqMMbxjFGV0YSxlXMN5jEmMKYprAdIFZmDmSeSHzGxZLlg6WW6x6rK2s99gs2aaxfWMPZ9/NocTRxfGFM5HzApcj1xZuTe4FPFI8U3mFeCfxCfNN45fhXyygI7BD0FXwilCq0A/hXhEVkb2i4aJfxCaJG4lfkaiQlJM8JpUvLS19QqZMVl32llyfvIv8H4WtioVKekpvldeqFKiaqP5UO6jepRGqqaT5QeuA9iSdVF0rPUG9V/pHDBYY1hrFGNuayJsym740u2C+02KJ5QSrOutcmzjbQDtXe2sHY0cdJzVnJRcFV3k3BXdlD3VPXS8Tbxsfd99gvwT//ID6wIlBS4N3hVwMfRnOFCEXaRUVEV0RMzN2T9yDBLZE3aSw5IaUNak30zkyLDIzs+ZmX8xlz7PPryjYVPiuWLskq3RV2ZsK/cqSql01jLVedVPrHzbqNdU0n22VaytsP9op3VXUfbpXta+x/+5Em0mzJ/+dGj/t8AyNmf2zvs9JmHt6vvmCpYtEFrcu+bYsc/m9lSGrTq9xWbtvveWGbZtMNm/ZarJt+w6rnft3u+45uy9s/4ODOYd+Hmk/Jn58xUnrU+fOJJ/9dX7SRe1LR68kXv13fc5Nm1t379TfU75/4mHeY7En+59lvhB5efB1/lv5dxc+NH0y/fzq64Lv4T8Ffp360/rP8f9/AA0ADzT6lvFdAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAADBSURBVHjazJSxDoIwEIa/Etkc9AEclAchrizMbMaEnTegr2GcfQPiyovgZgLv4FAXlQo9hRATb2rv7rvr31yrDOPMG5nP7LnY2l5FBJyx2pcfO0QUFERDj+QRAxC7on1XQkUKQEpFImp4WMoB9dqtOTHn+CbP2KJXXPA7JW5suEqis146+GSyhtB5Z6EMBE4gkIGFE1hOGo0/B7SYpV2AJheBvEXa0fjy9ErVHT41RXSNwVAPB/Y0NOxcIfXzX+M+ACEjIJk9xFSpAAAAAElFTkSuQmCC';

```

#### crm_component_registry_chooser {#uMRegistryChooser}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_registry_chooser                           |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<style>
.edit {
    border: 1px solid black;
    float: right;
    background: url('light/images/buttons/dark.gray/edit.png') 50%;
    width: 30px;
    height: 22px;
    background-repeat: no-repeat;
    border-radius: 5px;
    border-color: gray;
}
.edited{
    background-color: #efefef;
}
</style>

<div innerId="textView" style="text-decoration:underline; cursor:pointer;width:calc(100% ); color:#06f; margin-bottom:2px"></div>
<input type="text" class="asf-textBox" innerId="name" style="width:calc(100% )"/>
<div style="color:#606060; text-decoration:underline" class="asf-InlineBlock asf-cursorPointer" innerId="add">+Создать</div>
<div style="color:#606060; margin-left:10px; text-decoration:underline" class="asf-InlineBlock asf-cursorPointer" innerId="browse">Выбрать из реестра</div>
<div style="color:#606060; margin-left:10px; text-decoration:underline" class="asf-InlineBlock asf-cursorPointer" innerId="delete">&#10005; Удалить</div>

```

JAVASCRIPT код:

``` xml

/**
 * обновить текстовое представление записи реестра
 */
model.updateTextView = function () {
    if (!model.getValue()) {
        model.textValue = "";
        model.asfDataId = null;
        model.trigger(AS.FORMS.EVENT_TYPE.dataLoad, [model]);
        return;
    }
    AS.FORMS.ApiUtils.getAsfDataUUID(model.getValue(), function (newAsfDataId) {
        model.asfDataId = newAsfDataId;
        AS.FORMS.ApiUtils.getDocMeaningContent(registry.registryID, newAsfDataId, function (text) {
            if (text === null || text === '') {
                model.textValue = i18n.tr('Документ');
            } else {
                model.textValue = text;
            }
            model.trigger(AS.FORMS.EVENT_TYPE.dataLoad, [model]);
        });
    });
};

/**
 * получить тесктовое представление записи реестра
 * @returns {string|string|*}
 */
model.getTextValue = function () {
    return model.textValue;
};

// подписываемся на событие модели об изменении содержания, чтобы подгрузить дополнительные данные
model.on(AS.FORMS.EVENT_TYPE.valueChange, function () {
    model.updateTextView();
});

/**
 * метод реализовывает вставку asfData
 * @param asfData
 */
model.setAsfData = function (asfData) {
    model.setValue(asfData.key);
};

/**
 * метод реализовывает получение данных компонента для сохранения
 * @param blockNumber
 * @returns {*}
 */
model.getAsfData = function (blockNumber) {
    return AS.FORMS.ASFDataUtils.getBaseAsfData(model.asfProperty, blockNumber, model.textValue, model.value);
};


/* инициализация отображения */


/**
 * реестр
 * @type {object}
 */
var registry = null;
/**
 * видимые колонки реестра
 * @type {Array}
 */
var registryColumns = [];


/**
 * поле ввода для поиска записей реестра
 * @type {XMLList|*}
 */
var input = jQuery(view.container).children("[innerId='name']");
/**
 * поле для отображения выбранной записи реестра
 * @type {XMLList|*}
 */
var textView = jQuery(view.container).children("[innerId='textView']");
/**
 * кнопка добавления записи
 * @type {XMLList|*}
 */
var addIcon = jQuery(view.container).children("[innerId='add']");
/**
 * кнопка выбора записи из реестра
 * @type {XMLList|*}
 */
var browseIcon = jQuery(view.container).children("[innerId='browse']");
/**
 * кнопка удаления текущей выбранной записи
 * @type {XMLList|*}
 */
var deleteIcon = jQuery(view.container).children("[innerId='delete']");

// кнопку удаления текущей выбраннйо записи скрываем
deleteIcon.hide();

// по нажатию на кнопку "выбрать из реестра" открываем стандартный диалог выбра записи реестра
browseIcon.click(function () {
    AS.SERVICES.showRegisterLinkDialog(registry, function (documentId) {
        model.setValue(documentId);
    });
});

// по нажатию на кнопку "создать" открываем форму создания записи реестра
addIcon.click(function () {
    if (!registry.rr_create) {
        alert("У вас нет прав на создание записей данного реестра");
        return;
    }

    var createPlayerDiv = jQuery("<div>");
    createPlayerDiv.css("width", "1000px");
    createPlayerDiv.css("height", "700px");

    createPlayerDiv.css("border", "1px solid #afafaf");

    var saveButton = jQuery("<button>", {class: "ns-approveButton ns-basicChooserApplyButton"});
    saveButton.button();
    saveButton.html(i18n.tr("Создать"));
    saveButton.css("margin", "auto");
    saveButton.css("display", "block");
    saveButton.css("margin-top", "10px");
    saveButton.css("margin-bottom", "10px");

    var player = AS.FORMS.createPlayer();

    player.view.setEditable(true);
    player.showFormData(registry.formId);
    player.view.appendTo(createPlayerDiv);

    player.model.on(AS.FORMS.EVENT_TYPE.dataLoad, function () {
        console.log(player.model);
        var registryModel = null;
        if (player.model.formCode === 'crm_form_contact') {
            registryModel = player.model.getModelWithId('crm_form_contact_lead_lead', 'crm_form_contact_lead');
        }
        if (player.model.formCode === 'crm_form_account') {
            registryModel = player.model.getModelWithId('crm_form_account_lead_lead', 'crm_form_account_lead');
        }
        if (player.model.formCode === 'crm_form_dealActivity') {
            registryModel = player.model.getModelWithId('crm_form_dealActivity_main_deal');
        }
        if (player.model.formCode === 'crm_form_leadActivity') {
            registryModel = player.model.getModelWithId('crm_form_leadActivity_main_lead');
        }
        if (registryModel != null) {
            registryModel.setValue(AS.SERVICES.getParameterByName("document_identifier", window.location.href));
        }
    });

    createPlayerDiv.append(saveButton);


    createPlayerDiv.dialog({
        width: 1000,
        height: 700,
        modal: true
    });


    saveButton.click(function () {
        var valid = player.model.isValid();
        if (!valid) {
            alert(i18n.tr("Введите все обязательные поля"));
            return;
        }

        AS.SERVICES.showWaitWindow();
        AS.FORMS.ApiUtils.simpleAsyncGet("rest/api/registry/create_doc?registryID=" + registry.registryID, function (result) {
            if (result.errorCode != 0) {
                AS.SERVICES.hideWaitWindow();
                alert(i18n.tr("Во время сохранения данных по форме произошли ошибки. Обратитесь к администратору"));
                return;
            }
            player.model.asfDataId = result.dataUUID;
            player.saveFormData(function (result) {
                AS.SERVICES.hideWaitWindow();
                if (_.isUndefined(result)) {
                    alert(i18n.tr("Во время сохранения данных по форме произошли ошибки. Обратитесь к администратору"));
                    return;
                };


                createPlayerDiv.dialog("destroy");

                AS.FORMS.ApiUtils.getDocumentIdentifier(result, function (documentID) {
                    model.setValue(documentID);
                });

            });
        });

    });


});


// по нажатию на кнопку удалить  - удаляем выбранное значение
deleteIcon.click(function(){
    model.setValue(null);
});


// по нажатию на текстовое отображение  - открываем запись реестра на просмотр
textView.click(function () {
    var createPlayerDiv = jQuery("<div>");
    createPlayerDiv.css("width", "1000px");
    createPlayerDiv.css("height", "700px");

    var editButton = jQuery('<div class="edit"></div>');

    var saveButton = jQuery("<button>", {class: "ns-approveButton ns-basicChooserApplyButton"});
    saveButton.button();
    saveButton.html(i18n.tr("Сохранить"));
    saveButton.css("margin", "auto");
    saveButton.css("display", "block");
    saveButton.css("margin-top", "10px");
    saveButton.css("margin-bottom", "10px");

    if (registry.code == 'crm_registry_leadActivities' || registry.code == 'crm_registry_dealActivities') {
        createPlayerDiv.append(editButton);

        editButton.click(function () {
            if (player.view.editable) {
                player.view.setEditable(false);
                editButton.removeClass('edited');
                saveButton.hide();
            } else {
                player.view.setEditable(true);
                editButton.addClass('edited');
                saveButton.show();
            }
        });
    }

    createPlayerDiv.css("border", "1px solid #afafaf");

    var player = AS.FORMS.createPlayer();

    player.view.setEditable(false);
    player.showFormData(null, null, model.asfDataId, 0);
    player.view.appendTo(createPlayerDiv);
    createPlayerDiv.append(saveButton);
    saveButton.hide();

    createPlayerDiv.dialog({
        width: 1000,
        height: 700,
        modal: true
    });

    saveButton.click(function () {
        var valid = player.model.isValid();
        if (!valid) {
            alert(i18n.tr("Введите все обязательные поля"));
            return;
        }


        AS.SERVICES.showWaitWindow();
        player.saveFormData(function (result) {
            AS.SERVICES.hideWaitWindow();
            if (_.isUndefined(result)) {
                alert(i18n.tr("Во время сохранения данных по форме произошли ошибки. Обратитесь к администратору"));
                return;
            }
            ;


            createPlayerDiv.dialog("destroy");

            AS.FORMS.ApiUtils.getDocumentIdentifier(result, function (documentID) {
                model.setValue(documentID);
            });

        });

    });
});

// скрываем или отображаем поля ввода в зависимости от того режим чтения это или редактирования
if (editable) {
    //textView.hide();
} else {
    input.hide();
    addIcon.hide();
    browseIcon.hide();
    deleteIcon.hide();
}
addIcon.text('+' + i18n.tr('Создать'));
browseIcon.text(i18n.tr('Выбрать из реестра'));
deleteIcon.html('<div style="color:#606060; margin-left:10px; text-decoration:underline" class="asf-InlineBlock asf-cursorPointer" innerId="delete">&#10005;' + i18n.tr('Удалить') + '</div>');

// реализовываем метод обновления отображения согласно изменившимся данным модели
view.updateValueFromModel = function () {
    input.val("");
    if (model.getValue()) {
        textView.css("display", "");
        input.hide();
        textView.html(model.getTextValue());
        input.hide();
        if (editable) {
            deleteIcon.css("display", "");
        } else {
            input.hide();
            addIcon.hide();
            browseIcon.hide();
            deleteIcon.hide();
        }
    } else {

        if (editable) {
            input.css("display", "");
        } else {
            input.hide();
            addIcon.hide();
            browseIcon.hide();
            deleteIcon.hide();
        }

        textView.html("");
        input.text("");
        deleteIcon.hide();
    }
};

// подписываем на событие подгрузки дополнительных данных значения
model.on(AS.FORMS.EVENT_TYPE.dataLoad, function () {
    view.updateValueFromModel();
});


/**
 * если нет прав создания записи реестра, то кнопки создать не должно быть видно
 */
function validateIconsState() {
    addIcon.hide();
    if (registry.rr_create && editable) {
        addIcon.css("display", "");
    }
}

/**
 * инициализируем компонент (получаем реестр, колонки)
 */
function initComponent() {
    AS.FORMS.ApiUtils.simpleAsyncGet('rest/api/registry/info?code=' + model.code, function (reg) {
        registry = reg;

        registry.registryID = reg.registryID;

        registryColumns = [];
        registry.columns.forEach(function (col) {
            if (col.visible != 1) {
                return;
            }
            registryColumns.push(col);
        });

        registryColumns = registryColumns.sort(function (item1, item2) {
            var number1 = item1.order;
            var number2 = item2.order;
            if (number1 === number2) {
                if (item1.name < item2.name) {
                    return -1;
                } else if (item1.name > item2.name) {
                    return 1;
                }
            } else {
                if (number1 === 0) {
                    return 1;
                } else if (number2 === 0) {
                    return -1;
                } else if (number1 < number2) {
                    return -1;
                } else {
                    return 1;
                }
            }
            return 0;
        });
        model.updateTextView();
        view.updateValueFromModel();
        validateIconsState();
    });

}

// при вводе пользователя отображаем первые 10 результатов поиска
input.on("input", function () {
    var search = input.val();
    if (search.length === 0 || !registry) {
        AS.SERVICES.showDropDown([]);
        return;
    }

    AS.FORMS.ApiUtils.getRegistryData(registry.registryID, 0, 10, search, null, null, function (foundData) {
        var values = [];
        foundData.result.forEach(function (record) {
            var value = {value: record.documentID};
            var label = "";

            registryColumns.forEach(function (column) {
                if (record.fieldValue[column.columnID] !== undefined) {
                    label += record.fieldValue[column.columnID] + " - ";
                }
            });

            value.title = label;
            values.push(value);
        });

        AS.SERVICES.showDropDown(values, input, null, function (selectedValue) {
            model.setValue(selectedValue);
            view.updateValueFromModel();
        });

    });

});


setTimeout(function () {
    initComponent();
}, 0);


AS.SERVICES.getParameterByName = function(name, url) {
    if (!url) {
        url = window.location.href;
    }
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
};

```

#### crm_component_social_links_accounts {#uMSocialLinksAccounts}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_social_links_accounts                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<div class='social_link_account'>
    <div class='social_element'></div>
</div>

```

JAVASCRIPT код:

``` xml

var longIlond = model.playerModel.getModelWithId('crm_form_lead_main_account');

var checkExist = setInterval(function () {
    if (longIlond.asfDataId) {
        doAny(longIlond.asfDataId);
        clearInterval(checkExist);
    }
}, 100);

longIlond.on(AS.FORMS.EVENT_TYPE.valueChange, function (event, model) {
    var currentDataId = model.asfDataId;
    var checkExist = setInterval(function () {
        if (longIlond.asfDataId != currentDataId) {
            doAny(longIlond.asfDataId);
            clearInterval(checkExist);
        }
    }, 100);
    doAny(model.asfDataId);
});

function doAny(dataId) {
    var parent = jQuery('.social_link_account');
    jQuery.when(AS.FORMS.ApiUtils.loadAsfData(dataId, 0)).then(function (data) {
        parent.empty();
        var list = getSocial('crm_form_account_socialNetworks', 'crm_form_account_socialNetworks_socialNetworks-b', 'crm_form_account_socialNetworks_socialNetworksCombo-b', data);
        list.forEach(function (item) {
            if (item.key == 'Facebook Messenger') {
                createFacebookLink(item.value, parent);
            }
            if (item.key == 'Skype') {
                createSkypeLink(item.value, parent);
            }
        })
        list = getSocial('crm_form_account_phone', 'crm_form_account_phone_phone-b', 'crm_form_account_phone_phoneCombo-b', data);
        list.forEach(function (item) {
            if (item.key == 'Viber') {
                createViberLink(item.value, parent);
            }else if (item.key == 'Telegram') {
                createTelegramLink(item.value, parent);
            }else {
                createTelephoneLink(item.value, parent);
            }
        })
        list = getSocial('crm_form_account_email', 'crm_form_account_email_email-b', 'crm_form_account_email_emailCombo-b', data);
        list.forEach(function (item) {
           createMailLink(item.value, parent);
        });
    });
}

function createMailLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element mail"><a target="_blank" href="mailto:'+value+'">' + value + '</a></div>'));
    }
}

function createViberLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element viber"><a target="_blank" href="viber://add?number='+value+'">' + value + '</a></div>'));
    }
}

function createTelegramLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element telegram"><a target="_blank" href="https://telegram.me/'+value+'">' + value + '</a></div>'));
    }
}

function createTelephoneLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element tel"><a target="_blank" href="tel:'+value+'">' + value + '</a></div>'));
    }
}

function getSocial(idTable, valId, keyId, data) {
    var found = data.data.filter(function (item) {
        return item.id === idTable;
    });

    var list = [];
    found[0].data.forEach(function (item) {
        var id = item.id;
        if (id.indexOf(valId) !== -1) {
            var i = id.substring(id.indexOf(valId) + valId.length);
            if (!list[i]) {
                list[i] = {'value': item.value}
            } else {
                list[i].value = item.value;
            }
        }

        if (id.indexOf(keyId) !== -1) {
            var i = id.substring(id.indexOf(keyId) + keyId.length);
            if (!list[i]) {
                list[i] = {'key': item.value}
            } else {
                list[i].key = item.value;
            }
        }
    });
    return list;
}

function createFacebookLink(value, parent) {
    var id;
    if (value.indexOf("profile.php?id=") !== -1) {
        id = value.substring(value.indexOf('profile.php?id=') + 'profile.php?id='.length);
    } else {
        id = value.substring(value.indexOf('facebook.com/') + 'facebook.com/'.length);
    }
    if (id) {
        parent.append(jQuery('<div class="social_element facebook"><a target="_blank" href="http://m.me/' + id + '">' + value + '</a></div>'))
    }
}

function createSkypeLink(value, parent) {
    if(value){
        parent.append(jQuery('<div class="social_element skype"><a target="_blank" href="skype:' + value + '?call">' + i18n.tr("Позвонить") + ' ' + value + '</a></div>'))
        parent.append(jQuery('<div class="social_element skype"><a target="_blank" href="skype:' + value + '?chat">' + i18n.tr("Написать") + ' ' + value + '</a></div>'))
    }
}

```

#### crm_component_social_links_contacts {#uMSocialLinksContacts}

+--------------------------------------------------------+----------------------------------------------------------+
| Свойство                                               | Значение                                                 |
+========================================================+==========================================================+
| Код                                                    | crm_component_social_links_contacts                      |
+--------------------------------------------------------+----------------------------------------------------------+
| Использовать в формах                                  | включен                                                  |
+--------------------------------------------------------+----------------------------------------------------------+

HTML код:

``` xml

<style>
    .social_element{
    padding-left: 20px;
    padding-bottom: 5px;
}
.skype{
    background: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAgY0hSTQAAeiUAAICDAAD5/wAAgOkAAHUwAADqYAAAOpgAABdvkl/FRgAAAlJJREFUeNpc00+Il1UYxfHPc9935jdkojYtLAIDLaEomoRmoBgkhAg1JqhNtAnatIsWQdCmCFu6CWpbqwqaKCgQAoX+SBEU1DiuNBxR+iOTMzjqzPvep8WM86dnd+EcOOd7OeFU5cr1O2R9Q3EUd0qXhGnhT1VjKC6Qv2jbOYvJoGNkiUita/2opp5QHXDrwigekgh0CVfVOq3EO8S5W9Li5sqbW8wbN4ef8CMuYodaX9L038s8RBKpaPopuclWnZWOUPZiXMYEcT+eIy5gt4zPdIOHrYwI04vz2LmaJxYNxbjlnJVxgPqsdNNQ+wHlb10/Tn8KI7J8RznYijwvY0yimLE9Zv1biy4/xIOrDOphNSY09TfpGkZEfYJ+spXxBcYEat5lqQxEvSniRdUL2jqhq49ST2MYo2ugWW6eLlKzqf8eCyvvWbbDSvwq43VtTOI+Q+UjNXau80oM1X3FSAxvgdh6WeSs0h8XdcqNuFeWy0p5367mMYM4u0lfihp/rD/TGbUcJk4qXhX5uai/K/mprr/dQnfFSn4i1h1/FcvxrdCv9fpBya813SvC3JpoG/mMrtkuhtCUjbgxVrTDM5SvSNIRTdljUBZkPim9hbeJcbc1l91Ttmvr8xsVcm84Uan9ftdvnMYuxYyI13T5DVH1GClsy8ct1mN6k+sVwvlwKleJXl06pK8fr+0AzuGijBS5G/vXt7H6Y4zG8XByLc/8dbp8QFuP4SjKlmVsNgf6+Nk/g6fa/4nOiJwiHpEmsQ+NosNB1d24InxpUN51qZ3/bwDSyPF5FWIoNQAAAABJRU5ErkJggg==');
    background-repeat: no-repeat;
}
.viber{
    background: url('data:image/png;base64,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');
    background-repeat: no-repeat;
}
.facebook{
    background: url('data:image/png;base64,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');
    background-repeat: no-repeat;
}
.telegram{
    background: url('data:image/png;base64,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');
    background-repeat: no-repeat;
}
.tel{
    background: url('data:image/png;base64,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');
    background-repeat: no-repeat;
}
.mail{
    background: url('data:image/png;base64,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');
    background-repeat: no-repeat;
}
</style>
<div class='social_link_contact'>
    <div class='social_element'></div>
</div>

```

JAVASCRIPT код:

``` xml

var longIlond = model.playerModel.getModelWithId('crm_form_lead_main_contact');

var checkExist = setInterval(function () {
    if (longIlond.asfDataId) {
        doAny(longIlond.asfDataId);
        clearInterval(checkExist);
    }
}, 100);

longIlond.on(AS.FORMS.EVENT_TYPE.valueChange, function (event, model) {
    var currentDataId = model.asfDataId;
    var checkExist = setInterval(function () {
        if (longIlond.asfDataId != currentDataId) {
            doAny(longIlond.asfDataId);
            clearInterval(checkExist);
        }
    }, 100);
    doAny(model.asfDataId);
});

function doAny(dataId) {
    var parent = jQuery('.social_link_contact');
    jQuery.when(AS.FORMS.ApiUtils.loadAsfData(dataId, 0)).then(function (data) {
        parent.empty();
        var list = getSocial('crm_form_contact_socialNetworks', 'crm_form_contact_socialNetworks_socialNetworks-b', 'crm_form_contact_socialNetworks_socialNetworksCombo-b', data);
        list.forEach(function (item) {
            if (item.key == 'Facebook Messenger') {
                createFacebookLink(item.value, parent);
            }
            if (item.key == 'Skype') {
                createSkypeLink(item.value, parent);
            }
        })
        list = getSocial('crm_form_contact_phone', 'crm_form_contact_phone_phone-b', 'crm_form_contact_phone_phoneCombo-b', data);
        list.forEach(function (item) {
            if (item.key == 'Viber') {
                createViberLink(item.value, parent);
            }else if (item.key == 'Telegram') {
                createTelegramLink(item.value, parent);
            }else {
                createTelephoneLink(item.value, parent);
            }
        })
        list = getSocial('crm_form_contact_email', 'crm_form_contact_email_email-b', 'crm_form_contact_email_emailCombo-b', data);
        list.forEach(function (item) {
           createMailLink(item.value, parent);
        });
    });
}

function createMailLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element mail"><a target="_blank" href="mailto:'+value+'">' + value + '</a></div>'));
    }
}

function createViberLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element viber"><a target="_blank" href="viber://add?number='+value+'">' + value + '</a></div>'));
    }
}

function createTelegramLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element telegram"><a target="_blank" href="https://telegram.me/'+value+'">' + value + '</a></div>'));
    }
}

function createTelephoneLink(value, parent){
    if(value){
        parent.append(jQuery('<div class="social_element tel"><a target="_blank" href="tel:'+value+'">' + value + '</a></div>'));
    }
}

function getSocial(idTable, valId, keyId, data) {
    var found = data.data.filter(function (item) {
        return item.id === idTable;
    });

    var list = [];
    found[0].data.forEach(function (item) {
        var id = item.id;
        if (id.indexOf(valId) !== -1) {
            var i = id.substring(id.indexOf(valId) + valId.length);
            if (!list[i]) {
                list[i] = {'value': item.value}
            } else {
                list[i].value = item.value;
            }
        }

        if (id.indexOf(keyId) !== -1) {
            var i = id.substring(id.indexOf(keyId) + keyId.length);
            if (!list[i]) {
                list[i] = {'key': item.value}
            } else {
                list[i].key = item.value;
            }
        }
    });
    return list;
}

function createFacebookLink(value, parent) {
    var id;
    if (value.indexOf("profile.php?id=") !== -1) {
        id = value.substring(value.indexOf('profile.php?id=') + 'profile.php?id='.length);
    } else {
        id = value.substring(value.indexOf('facebook.com/') + 'facebook.com/'.length);
    }
    if (id) {
        parent.append(jQuery('<div class="social_element facebook"><a target="_blank" href="http://m.me/' + id + '">' + value + '</a></div>'))
    }
}

function createSkypeLink(value, parent) {
    if(value){
        parent.append(jQuery('<div class="social_element skype"><a target="_blank" href="skype:' + value + '?call">' + i18n.tr("Позвонить") + ' ' + value + '</a></div>'))
        parent.append(jQuery('<div class="social_element skype"><a target="_blank" href="skype:' + value + '?chat">' + i18n.tr("Написать") + ' ' + value + '</a></div>'))
    }
}

```
