### Реестры {#registries}

-   [Каталог товаров и услуг](#registryCatalog):

    *   [Каталог товаров и услуг](#registryItems)

    *   [Прайс-лист](#registryPriceList)

    *   [Темы сотрудничества](#registryThemes)

-   [Шаблоны документов](#registryTemplates):

    *   [Договоры поставки (единовременная оплата)](#registryContractDeliveryAll)

    *   [Договоры поставки (оплата частями)](#registryContractDeliveryPart)

    *   [Акты приема-передачи товара](#registryCertificates)

    *   [Коммерческие предложения](#registryOffer)

*   [Маркетинговое мероприятие](#registryEvent)
*   [Лид](#registryLead)
*   [Сделка](#registryDeal)
*   [Аккаунт](#registryAccount)
*   [Контакт](#registryContact)
*   [Активность лида](#registryLeadActivity)
*   [Активность сделки](#registryDealActivity)
*   [% комиссии](#registryComission)

#### Каталог товаров и услуг {#registryCatalog}

Группа реестров для организации каталога товаров и услуг, предоставляемых организацией.

##### Каталог товаров и услуг {#registryItems}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_items                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_item                                          |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | Все маркетологи, маркетологи-специалисты               |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | "Все маркетологи" - просмотр списка, просмотр данных   |
|                                                        | "Маркетологи-специалисты" - все права                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю crm_form_item_name                             |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                         |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_item_name                                     | Наименование товара                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_item_id                                       | Код товара                                             | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Прайс-лист {#registryPriceList}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_price_list                                |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_price                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | Все маркетологи, маркетологи-специалисты               |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | "Все маркетологи" - просмотр списка, просмотр данных   |
|                                                        | "Маркетологи-специалисты" - все права                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю crm_form_item_name                             |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                         |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_price_item_name                               | Наименование товара                                    | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_price_unit                                    | Единица измерения                                      | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_price_price                                   | Цена                                                   | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Темы сотрудничества {#registryThemes}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_themes                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_theme                                              |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | Все маркетологи                                             |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Все                                                         |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_theme_theme                                |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по возрастанию                                              |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_theme_theme                                   | Тема сотрудничества                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Шаблоны документов {#registryTemplates}

Группа реестров для обеспечения формирования шаблонов документов. В каждом из этих реестров настроено событие активации элемента:

*Действия:*

- Тип действия - Отправка документа по форме

- Название - Отправка документа по форме

- Адресат - `email`

> **Примечание:** для корректной работы процесса "Отправка документа по форме" **обязательно** должен быть включен флаг 
"Интеграция с почтой" (Конфигуратор - Настройки системы - Настройки почты). На стороне клиента также должен быть настроен 
аккаунт электронной почты.

##### Договоры поставки (единовременная оплата) {#registryContractDeliveryAll}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_100                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_100                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_100_contract_number         | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_contract_date           | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_theme                   | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_client_account          | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_100_sum_total               | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

Для реестра настроено событие активации: 

-   действие: "Отправка документа по форме";

-   адресат: `email`;

-   код: `crm_process_sending_doc`

##### Договоры поставки (оплата частями) {#registryContractDeliveryPart}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contracts_delivery_part                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contract_delivery_part                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contract_delivery_part_contract_number        | Номер договора                                         | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_contract_date          | Дата договора                                          | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_theme                  | Тема договора                                          | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_client_account         | Заказчик                                               | 4                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contract_delivery_part_sum_total              | Сумма договора                                         | 5                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

Для реестра настроено событие активации: 

-   действие: "Отправка документа по форме";

-   адресат: `email`;

-   код: `crm_process_sending_doc`

##### Акты приема-передачи товара {#registryCertificates}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_certificates                              |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_certificate                                   |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_certificate_table3_contract                   | Основание договора                                     | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_certificate_table2_date                       | Дата акта                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

##### Коммерческое предложение {#registryOffer}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_offer                                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_offer                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_offer_whom_position                           | Должность                                              | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_account	                         | Аккаунт                                                | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_whom_fullname                           | ФИО                                                    | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_offer_from_user                               | От кого                                                | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Маркетинговые мероприятия {#registryEvent}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_events                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_event                                         |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_event_main_name                               | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_cost                               | Стоимость                                              | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_main_event                              | Мероприятие                                            | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_event_responsibleManager_responsible          | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Лиды {#registryLead}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_lead                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_lead                                          |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по полю crm_form_lead_deals_budget                     |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_lead_deals_theme                              | Тема сотрудничества                                    | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_budget                             | Потенциальный бюджет                                   | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_deals_status                             | Статус                                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_lead_responsibleManager_responsible           | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Сделки {#registryDeal}

Свойства реестра:

+--------------------------------------------------------+-----------------------------------------------------------------------+
| Свойство                                               | Значение                                                              |
+========================================================+=======================================================================+
| Код                                                    | crm_registry_deals                                                    |
+--------------------------------------------------------+-----------------------------------------------------------------------+
| Форма документа                                        | crm_form_deals                                                        |
+--------------------------------------------------------+-----------------------------------------------------------------------+
| Группа                                                 | все маркетологи                                                       |
+--------------------------------------------------------+-----------------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Создание, Изменение, Редактирование |
+--------------------------------------------------------+-----------------------------------------------------------------------+
| Сортировка                                             | по полю crm_form_deal_main3_budget                                    |
+--------------------------------------------------------+-----------------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                           |
+--------------------------------------------------------+-----------------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_deal_main1_lead                               | Лид                                                    | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main2_theme                              | Тема сотрудничества                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_main3_budget                             | Бюджет                                                 | 3                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_deal_responsibleManager_responsible           | Ответственный менеджер                                 | 4                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Аккаунты {#registryAccount}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_accounts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_accounts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_account_main_name                             | Наименование                                           | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_main_info                             | Описание                                               | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_account_responsibleManager_responsible        | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

Сопоставление полей реестров:

*   При сохранении изменений заполнятся ссылкой на текущую запись реестра
    связанные поля в следующих реестрах:

    *   [Лид](#registryLead) - crm_form_lead_main_account
    *   [Аккаунт](#registryAccount), который указан в поле "Материнский
        аккаунт" текущей записи - crm_form_account_childAccount_account
    *   [Аккаунт](#registryAccount), который указан в поле "Дочерний
        аккаунт" текущей записи - crm_form_account_parentAccount_parentAccount

#### Контакты {#registryContact}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_contacts                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_contacts                                      |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_contact_main_fullName                         | Полное имя                                             | 1                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_main_position                         | Должность                                              | 2                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_contact_responsibleManager                    | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

Сопоставление полей реестров:

*   При сохранении изменений заполнятся ссылкой на текущую запись реестра
    связанные поля в следующих реестрах:

    *   [Лид](#registryLead) - `crm_form_lead_main_contact`

#### Активности лидов {#registryLeadActivity}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_leadActivities                            |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_leadActivity                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_leadActivity_activities                       | Активности                                             | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_leadActivity_main_lead                        | Лид                                                    | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_leadActivity_responsibleManager_responsible   | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### Активности сделок {#registryDealActivity}

Свойства реестра:

+--------------------------------------------------------+--------------------------------------------------------+
| Свойство                                               | Значение                                               |
+========================================================+========================================================+
| Код                                                    | crm_registry_dealActivities                            |
+--------------------------------------------------------+--------------------------------------------------------+
| Форма документа                                        | crm_form_dealActivity                                  |
+--------------------------------------------------------+--------------------------------------------------------+
| Группа                                                 | все маркетологи                                        |
+--------------------------------------------------------+--------------------------------------------------------+
| Права                                                  | все                                                    |
+--------------------------------------------------------+--------------------------------------------------------+
| Сортировка                                             | по дате создания                                       |
+--------------------------------------------------------+--------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                            |
+--------------------------------------------------------+--------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_dealActivity_activities                       | Активности                                             | 1                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_dealActivity_main_deal                        | Сделка                                                 | 2                          | да                        |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| crm_form_dealActivity_responsibleManager_responsible   | Ответственный менеджер                                 | 3                          | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+

#### % комиссии {#registryComission}

Свойства реестра:

+--------------------------------------------------------+-------------------------------------------------------------+
| Свойство                                               | Значение                                                    |
+========================================================+=============================================================+
| Код                                                    | crm_registry_comission                                      |
+--------------------------------------------------------+-------------------------------------------------------------+
| Форма документа                                        | crm_form_comission                                          |
+--------------------------------------------------------+-------------------------------------------------------------+
| Группа                                                 | маркетологи-менеджеры                                       |
+--------------------------------------------------------+-------------------------------------------------------------+
| Права                                                  | Просмотр списка, Просмотр данных, Изменение, Редактирование |
+--------------------------------------------------------+-------------------------------------------------------------+
| Сортировка                                             | по дате создания                                            |
+--------------------------------------------------------+-------------------------------------------------------------+
| Направление сортировки                                 | по убыванию                                                 |
+--------------------------------------------------------+-------------------------------------------------------------+

Отображаемые поля формы:

+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+
| Идентификатор колонки                                  | Название поля                                          | Номер                      | Значащее содержимое       |
+========================================================+========================================================+============================+===========================+
| crm_form_comission_main                                | % комиссии                                             |                            | нет                       |
+--------------------------------------------------------+--------------------------------------------------------+----------------------------+---------------------------+







