### Общие сведения {#overview}

Synergy CRM устанавливается отдельным пакетом. Возможные варианты установки:

1. Clean CRM - установка конфигурации CRM без данных (чистая установка с загрузка 
   преднастроенной БД и хранилища Synergy)

2. Demo CRM - установка конфигурации CRM с демо-данными (с загрузкой преднастроенной 
   БД и хранилища Synergy с демонстрационными данными)

*(В связи подготовкой демо данных, просьба временно не использовать данный вид*
*установки, о его готовности будет сообщено дополнительно)*

> **Варианты установки Clean CRM и Demo CRM  удаляют все текущие  данные в системе!**

3. Install/Upgrade Configuration - установка приложения CRM и загрузка его конфигурации

4. Manual - установка приложения CRM без автоматической загрузки конфигурации


**Требования:**

Для работы данного приложения требуется:

1. Установить Synergy 3.12 и выше.

2. Обязательно обновить базу данных в административном приложении.

3. Доступ в интернет для установки java  8-ой версии. В случае отсутствия доступа, 
   необходимо предварительно скачать и установить пакет. В ходе установки Java 
   необходимо принять лицензию.


### Установка конфигурации CRM без данных {#crm_without_data}
 
Для установки конфигурации CRM без данных (чистая установка) необходимо выполнить 
команду:

`# aptitude install arta-synergy-apps-crm`

В ходе установки необходимо выполнить следующее:

1. Выбрать из предложенного списка установку Clean CRM;

![Выбор установки](resources/img/clean_crm.png)

2. Указать URL до Synergy, на котором производится работа

![Ввод URL до Synergy](resources/img/url_synergy.png)

Например: http://192.168.1.172:8080/Synergy

3. Ввести пароль MySql

![Ввод пароля для Mysql](resources/img/mysql.png)

Пароль для MySQL - root

#### Настройки в подсистеме администрирования и Конфигураторе {#crm_without_data_settings}

При установке  будут настроены

**В административном приложении:**

-   Пользователи:

    - Системный Пользователь (от имени которого будут выполняться сопоставления)

    - Пользователь1- Жуматаев

    - Пользователь2- Муканова

    - Пользователь3 - Султангазина
 
    - Пользователь4 - Калиев 

![Управление пользователями](resources/img/users.png)

Всем разрешен доступ в систему, сгенерированы логины/пароли, прочими свойствами не обладают.

-   Орг.структура:

    - Организация (подразделение, руководитель отсутствует)

          - Отдел маркетинга (подразделение, руководитель Пользователь1)

                - Специалист по маркетингу (должность, на нее назначен Пользователь2)

          - Отдел продаж (подразделение, руководитель Пользователь3)

                - Специалист по продажам (должность, на нее назначен Пользователь4)

![Организационная структура](resources/img/structure.png)

-   На "Отдел маркетинга" настроено отображение только следующих модулей:

    - Ежедневник

    - Хранилище -> Реестры

    - Проекты

    - Маркетинг

-   На "Отдел продаж" настроено отображение только следующих модулей:

    - Ежедневник

    - Хранилище -> Реестры

    - Проекты

    - Управление продажами

![Управление модулями - Отдел маркетинга](resources/img/modules.png)

![Управление модулями - Отдел продаж](resources/img/modules2.png)

-   Группы:

    - Все маркетологи

          - Маркетологи-менеджеры (Пользователь1)

          - Маркетологи-специалисты (Пользователь2 и Системный Пользователь)

    - Все специалисты по продажам

          - Менеджеры по продажам (Пользователь4)

          - Специалисты по продажам (Пользователь3 и Системный Пользователь)

**В конфигураторе:**

-   [Типовая конфигурация CRM](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html)

-   Прочие опции (их значения отличаются от дефолтных):

    - форма завершения "Комментарий": "Требовать подтверждения результата" - нет

    - "Отображать полное ФИО пользователя" - да

    - "Отображать ФИО и должность пользователя на момент подписи в листе подписей" - да

    - "Отображать в ходе исполнения будущие этапы" - да

    - "Требовать ввода комментария при согласовании/утверждении" - да

    - "Требовать ввода комментария при отказе в согласовании/утверждении" - да

    - "Форма завершения по-умолчанию" - Комментарий

    - "Переназначение работ" - везде переназначить работы на непосредственного руководителя

    - "Название системы" - ARTA Synergy CRM

    - "Интеграция с почтой" - да

>**Примечание:**
>
>«Интеграция с почтой» предназначена для отправки уведомлений, шаблонов документов 
>(коммерческое предложение, акт приема-передачи, договора) заказчикам на почту. 
>[Настройка электронной почты](http://tdd.lan.arta.kz/docs/cases/crm/user-manual/html/sec.appendix.html#user_settings)

В конфигураторе будут настроены права  и маршруты активации  в реестрах согласно 
типовой конфигурации.

После проверки всех настроек в основном приложение Synergy должно отображаться как
в илл. Модуль Маркетинг.

![Модуль Маркетинг](resources/img/funnel_1.png)


### Установка конфигурации CRM с демо - данными {#crm_demo_data}

Временно не доступен данный вид установки, в связи с реализацией демо данных.


### Установка конфигурации CRM - Install/Upgrade Configuration {#crm_install_upgrade}

Данный вариант установки Install/Upgrade Configuration отличается от других видов тем, 
что автоматически загружается конфигурация через API, не удаляя при этом информацию 
пользователя.

**Требуется:**
Перед установкой необходимо создать системного пользователя, от имени которого будут 
выполняться все сопоставления реестров в Synergy

**Внимание! Системный пользователь должен быть обязательно назначен на должность** 
**и иметь доступ в конфигуратор.**

Для установки конфигурации CRM необходимо выполнить команду:

`# aptitude install arta-synergy-apps-crm`

В ходе установки необходимо выполнить следующее:

1. Выбрать из предложенного списка установку Install/Upgrade Configuration;

   ![Типы установки](resources/img/install_type.png)

2. Указать URL до Synergy, на котором производится работа

   ![Ввод URL до Synergy](resources/img/url_synergy.png)

   Например: http://192.168.1.172:8080/Synergy

3. Ввести логин и пароль Системного пользователя от имени которого, выполняются все 
   сопоставления реестров в Synergy

>**Примечание:**
>
>Эти данные будут прописаны в файле `/opt/synergy/jboss/standalone/configuration/arta/apps/crm/crm.properties`:
> 
>`synergy.address=http://localhost:8080/Synergy`
> 
>`user.login=логин`
> 
>`user.password=пароль`


#### Настройка в подсистеме администрирования и Конфигураторе {#crm_install_upgrade_settings}

Необходимо выполнить следующие настройки:

**В административном приложении:**

1. Внести Системного пользователя в группу “Все маркетологи”

2. Настроить права на внешний модуль нужному подразделению в  организационной  структуре

**В конфигураторе:**

3. Должны быть настроены права на следующие реестры:

+---------------------------+-----------------------+----------------------+
| **Реестр**                | **Группа**            | **Права**            |
+===========================+=======================+======================+
| Маркетинговые мероприятия | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Лиды                      | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Сделки                    | Все маркетологи       | Просмотр списка,     |
|                           |                       | Просмотр данных,     |
|                           |                       | Создание, Изменение, |
|                           |                       | Редактирование       |
+---------------------------+-----------------------+----------------------+
| Аккаунты                  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Контакты                  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Активности лидов          | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Активности сделок         | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| % комиссии                | Маркетологи-менеджеры | Просмотр списка,     |
|                           |                       | Просмотр данных,     |
|                           |                       | Изменение,           |
|                           |                       | Редактирование       |
+---------------------------+-----------------------+----------------------+
| Темы сотрудничества       | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Каталог товаров и услуг   | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Прайс-лист                | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+
| Договоры поставки         | Все маркетологи       | Все                  |
| (единовременная оплата)   |                       |                      |
+---------------------------+-----------------------+----------------------+
| Договоры поставки         | Все маркетологи       | Все                  |
| (оплата частями)          |                       |                      |
+---------------------------+-----------------------+----------------------+
| Акты приема-передачи      | Все маркетологи       | Все                  |
| товара                    |                       |                      |
+---------------------------+-----------------------+----------------------+
| Коммерческое предложение  | Все маркетологи       | Все                  |
+---------------------------+-----------------------+----------------------+

>**Примечание:**
>
>Данные настройки создаются только в начальной установке CRM, при последующих обновлениях 
>конфигурации не изменяются.


### Установка конфигурации CRM  с загрузкой конфигурации  пользователем - Manual {#crm_manual}

Установка приложения CRM без автоматической загрузки конфигурации.

**Требуется:**
Перед установкой необходимо создать системного пользователя, от имени которого будут 
выполняться все сопоставления реестров в Synergy.

**Внимание! Системный пользователь должен быть обязательно назначен на должность и иметь** 
**доступ в конфигуратор.**

Для установки конфигурации CRM необходимо выполнить команду:

`# aptitude install arta-synergy-apps-crm `

В ходе установки необходимо выполнить следующее:

1. Выбрать из предложенного списка установку Manual

   ![Тип установки](resources/img/crm_manual.png)

2. Указать URL до Synergy, на котором производится работа

   ![URL до Synergy](resources/img/url_synergy.png)

3. Ввести логин и пароль Системного пользователя от имени которого, выполняются все 
   сопоставления реестров в Synergy


#### Настройка в подсистеме администрирования и Конфигураторе {#crm_manual_settings}

Необходимо выполнить следующие настройки:

**В конфигураторе:**

1. Переходим в импорт/экспорт конфигурации для загрузки [типовой конфигурации](http://tdd.lan.arta.kz/docs/cases/crm/methodologist-manual/html/sec.crm_conf_consist.html)

   Файл типовой конфигурации лежит в `/opt/synergy/apps/crm/crm_configuration.xml`

   ![Импорт конфигурации](resources/img/import_configuration.png)

2. Изменить URL до Synergy в настройках внешнего модуля в Конфигураторе  с адресом 
   `http://host:port/crm`, в нашем случае - `http://192.168.1.234:8080/crm`

   ![Настройки внешнего модуля](resources/img/module.png)

3. Изменить в пользовательских компонентах crm_component_leads_dashboard, crm_component_deals_dashboard 
   URL в ссылке

4. Добавить пользователей в группу:   “Все маркетологи”, распределить их между менеджерами 
   и специалистами. Добавить Системного пользователя в общую группу “Все маркетологи”.

**В административном приложении:**

Настроить права на внешний модуль нужному подразделению в  организационной  структуре.


### Настройка Kibana для визуализации данных {#kibana_settings}

Пакет Kibana устанавливается одновременно при установке пакета CRM.

В конфигурационном файле Kibana: `/etc/kibana/kibana.yml` требуется изменить параметр 
`server.host`, указав для него IP-адрес сервера Kibana и раскомментировать соответствующую 
строку:

```xml
 # Kibana is served by a back end server. This setting specifies the port to use.
    #server.port: 5601

    # Specifies the address to which the Kibana server will bind. IP addresses and host names are both valid values.
    # The default is 'localhost', which usually means remote machines will not be able to connect.
    # To allow connections from remote users, set this parameter to a non-loopback address.
    server.host: "192.168.1.79"

    # Enables you to specify a path to mount Kibana at if you are running behind a proxy. This only affects
    # the URLs generated by Kibana, your proxy is expected to remove the basePath value before forwarding requests
    # to Kibana. This setting cannot end in a slash.
    #server.basePath: ""

    # The maximum payload size in bytes for incoming server requests.
    #server.maxPayloadBytes: 1048576

    # The Kibana server's name.  This is used for display purposes.
    #server.name: "your-hostname"

    # The URL of the Elasticsearch instance to use for all your queries.
    #elasticsearch.url: "http://localhost:9200"

    # When this setting’s value is true Kibana uses the hostname specified in the server.host
    # setting. When the value of this setting is false, Kibana uses the hostname of the host
    # that connects to this Kibana instance.
    #elasticsearch.preserveHost: true
```

Перезапустить Kibana

Запуск Kibana осуществляется командой:

`/etc/init.d/kibana start`

По умолчанию Kibana запускается по адресу `localhost:5601`

**Индексация данных форм**

Загрузка данных в Elasticsearch осуществляется с помощью процесса индексации данных форм 
Административное приложение -> Обслуживание системы -> Управление индексом форм.

**Проиндексировать все данные форм** (это может занять время, зависит от количества записей
в системе)

В это время для каждой формы и каждого компонента этой формы в Synergy создается несколько 
индексов. Каждый из этих индексов будет отображен в Kibana со своим кодом, как используемое 
поле.

![Управление индексом данных форм](resources/img/indexes.png)

Для проверки установки Kibana, необходимо в основном приложении Synergy перейти в модуль 
Маркетинг (или Управление продажами) вкладка Аналитика. Если все настроено правильно, 
то должны иметь следующее:

![Аналитика](resources/img/analytics.png)


### Устранение неполадок {#troubleshooting}

1. **Проблема:** в модуле "Маркетинг" ничего не отображается

**Возможная причина:** при установке неправильно указан URL для Synergy

**Пути устранения:** в терминале необходимо выполнить команду:

` # dpkg-reconfigure arta-synergy-apps-crm` или исправить настройки в Конфигураторе:

a. Внешний модуль - прописать адрес приложения.

b. Пользовательские компоненты - `crm_component_deals_dashboard`,  `crm_component_leads_dashboard`  
   изменить URL в ссылке.

2. **Проблема:** нет реестров у пользователя

**Возможная причина:** не настроены права для реестров

**Пути устранения:** необходимо настроить в Конфигураторе права пользователю на все реестры 
CRM, согласно [типовой конфигурации](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html).

3. **Проблема:** не отображаются Лиды или не работают сопоставления реестров

![Реестр "Лиды"](resources/img/lead_error.png)

![Модуль "Маркетинг"](resources/img/marketing_error.png)

**Возможная причина:** неправильно прописаны очереди в файле

**Пути устранения:**

1. Прописать очередь в файле `/opt/synergy/jboss/standalone/configuration/arta/api-observation-configuration.xml`

```xml
<listener>
 <queue>java:jboss/queues/Synergy/FormDataChange</queue>
 <event>event.form.formdata.change</event>
</listener>
<listener>
 <queue>java:jboss/queues/Synergy/LeadDelete</queue>
 <event>crm.lead.delete</event>
</listener>
```

2. В файл `/opt/synergy/jboss/standalone/configuration/standalone-onesynergy.xml` 
добавить в секцию 

```xml
<jms-destinations/>`
```

очередь:

```xml
               <jms-queue name="FormDataChange">
                    <entry name="queue/FormDataChange"/>
    <entry name="java:jboss/queues/Synergy/FormDataChange"/>
                    <durable>true</durable>
                </jms-queue>
                <jms-queue name="LeadDelete">
                    <entry name="queue/LeadDelete"/>
                    <entry name="java:jboss/queues/Synergy/LeadDelete"/>
                    <durable>true</durable>
                </jms-queue>
```

4. **Проблема:** при переходе в модуль Маркетинг, в рабочей области отображается ошибка 
страницы

**Возможная причина:** не зедеплоилось приложение

**Пути устранения:**  В `/opt/synergy/jboss/standalone/deployments` удалить файл 
`crm.war.undeployed (crm.war.deployed)`

5. **Проблема:** при переходе в модуль Маркетинг,  вкладка Аналитика отображается: 
Попытка соединения не удалась

**Возможная причина:** не запущена Kibana

**Пути устранения:** запустить Kibana /etc/init.d/kibana start

6. **Проблема:** при переходе в модуль Маркетинг, в раздел Аналитика отображается следующие:

![Ошибка](resources/img/error.png)

**Возможная причина:** в пользовательском компоненте, не прописались ссылки

**Пути устранения:**

a. Запустить Kibana по адресу localhost:5601

b. Перейти в раздел Dashboard (на панели) - выбрать Share

   ![Dashboard](resources/img/dashboard.png)

c. В поле Embedded iframe копировать ссылку.

d. Перейти в конфигуратор - Пользовательские компоненты.
e. Выбрать crm_component_leads_dashboard (для маркетинга) и вставить ссылку, изменив 
   параметры height="100%" width="100%"

7. **Проблема:** после установки CRM на дашбордах все кириллические символы стали 
отображаться как ??????????

**Возможная причина:** проблема с локалью

**Пути устранения: **

a. необходимо  остановить все сервисы в указанном порядке:

   1. synergy

   2. kibana

   3. elasticsearch

   4. mysql

b. установить локаль по умолчанию en_US.UTF-8, для этого выполним команду:

   `dpkg-reconfigure locales`

   В открывшемся окне  можно выбрать все локали:

   ![Локали](resources/img/locales.png)

   Затем указать локаль по умолчанию: выбрать из списка en_US.UTF-8

   ![Локаль по умолчанию](resources/img/locale.png)

c. запустить все остановленные сервисы в указанном порядке:

   1. mysql

   2. elasticsearch

   3. kibana

   4. synergy

d. в приложение администратора запустить переиндексацию в разделе "Управление индексом форм"

