## Модуль "Управление продажами" {#crm16.dealManagement}

*   Модуль доступен для подразделения "Отдел продаж".

*   Модуль содержит групповые кнопки, переключающие вид отображения воронки:
    *   "Воронка"
    *   "Поток"

*   Модуль также содержит кнопки, отображающие [диаграммы Kibana](#crm_dashboards):

    *    "Аналитика"  
    *    "Продуктивность"  

*   По умолчанию выбран вид отображения "Поток".

*   По нажатию на кнопку "Воронка" основная область содержит
    [воронку продаж](#crm16.funnel).

*   По нажатию на кнопку "Поток" основная область содержит
    [Поток продаж](#crm16.pipeline).

*   По нажатию на кнопку "Аналитика" основная область содержит
    [дашборд "Аналитика"](#crm26.dashboard).

*   По нажатию на кнопку "Аналитика" основная область содержит
    [дашборд "Продуктивность"](#crm31.productivity).

*   Боковая панель содержится в рабочей области только для видов "Воронка" 
    и "Поток".

*   При переключении вида отображения настройки в боковой панели не
    изменяются.

### Боковая панель {#crm16.sidePannel}

*   Изменение значений настроек боковой панели должно сопровождаться
    анимацией загрузки.

#### Пользователи {#crm16.users}

*   Настройка представлена компонентом выбора пользователей.

*   Компонент содержит авторизованного пользователя, а также его подчиненных
    из подразделения "Отдел продаж".

*   Компонент позволяет выбрать:

    *   всех пользователей;
    *   нескольких пользователей;
    *   одного пользователя;
    *   ни одного пользователя.

*   По умолчанию выбран авторизованный пользователь.

#### Фильтры {#crm16.filters}

*   Доступно три параметра фильтрации:

    *   Период
    *   Статус сделки
    *   Стоимость

*   При фильтрации сделок за период учитывается только факт смены значения
    в поле "Статус" записи реестра
    [Сделка](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.registryDeal).
    Если за указанный период значение этого поля изменялось несколько раз,
    то в воронку должно войти только последнее.

*   Параметр "Период" представлен выпадающим списком и двумя компонентами
    выбора даты, разделенными тире.

*   Выпадающий список периода содержит пункты:

    *   "За все время" - воронка содержит все сделки с момента создания
        записи реестра до текущего времени на сервере.

    *   "Прошедшая неделя" - учитываются только те сделки, у которых
        изменился статус за последнюю неделю от текущего дня на сервере.

    *   "Прошедший месяц" - учитываются только те сделки, у которых
        изменился статус за последний месяц от текущего дня на сервере.

    *   "Прошедший квартал" - учитываются только те сделки, у которых
        изменился статус за последний квартал от текущего дня на сервере.

    *   "Прошедший год" - учитываются только те сделки, у которых изменился
        статус за последний год от текущего дня на сервере.

    *   "Произвольный период" - учитываются только те сделки, у которых
        изменился статус за указанный пользователем период.

*   Компоненты выбора даты активны только при выбранном пункте
    "Произвольный период".

*   Компоненты выбора даты по умолчанию отображают период
    `текущий день на сервере + месяц`.

*   Параметр "Статус" представлен выпадающим списком с пунктами:

    *   "Все";
    *   значение crm_dict_dealStatus_type записи справочника
        [crm_dict_dealStatus](#dictionaryDealStatus), у которой
        crm_dict_dealStatus_end=1;
    *   значения crm_dict_dealStatus_type всех записей справочника
        [crm_dict_dealStatus](#dictionaryDealStatus), у которой
        crm_dict_dealStatus_quality=0.

*   Статус "Все" включает в себя все записи справочника
    [crm_dict_dealStatus](#dictionaryDealStatus) со значением
    crm_dict_dealStatus_quality=1.

*   Параметр "Стоимость" представлен двумя числовыми полями:

    *   минимальная граница значения поля
        [Бюджет](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.formDeal)
        всех сделок
    *   максимальная граница значения поля
        [Бюджет](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.formDeal)
        всех сделок

*   По умолчанию выбраны:

    *   Период - "За все время"
    *   Статус - "Все"
    *   Стоимость:
        *   от - минимальная значение поля
            [Бюджет](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.formDeal)
        *   до - максимальная значение поля
            [Бюджет](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.formDeal)

### Воронка продаж {#crm16.funnel}

*   Воронка продаж представлена в виде кнопок статусов сделки.

*   Статусы сделки определяются записями справочника
    [crm_dict_dealStatus](#dictionaryDealStatus).

*   Кнопки статусов содержат два типа значений:

    *   количество сделок данного статуса;
    *   коэффициент конвертации.

*   Значение отображаются в формате:

    `%название_статуса%`

    `%количество_сделок_статуса% (%коэффициент_конвертации%)`

*   Коэффициент конвертации отсутствует для кнопки первого статуса.

*   Коэффициент конвертации рассчитывается как:

    `количество сделок последующего статуса / количество сделок предыдущего
    статуса * 100%`

*   Изменение количества сделок и коэффициентов конвертации должно происходить
    в режиме реального времени.

*   Кнопки статусов сделок имеет форму трапеции.

*   Ширина кнопок статична:

    *   максимальная - 450px по наибольшей горизонтальной стороне кнопки;
    *   минимальная - 150px по наименьшей горизонтальной стороне кнопки.

*   Кнопки воронки продаж имеют одинаковую статичную высоту, пропорционально
    максимальной высоте воронки.

*   Минимальная высота кнопок - 40px.

*   Максимальная высота всей воронки - 500px.

*   Если воронка содержит один статус, то его кнопка также отображается в
    виде трапеции на максимальную высоту всей воронки.

*   Если не выбран ни один пользователь воронка отображается пустой:

    *   значения количества сделок и коэффициента конвертации - 0;
    *   кнопки имеют минимальную высоту.

### Панели стоимости и комиссии {#crm16.cost_comission}

*   Стоимость продаж в панели - сумма значений компонента
    [Бюджет](#formDeal) всех сделок текущей воронки.

*   Комиссия продаж в панели рассчитывается как:

    `стоимость продаж * % комиссии продаж`

    где `% комиссии продаж` - значение поля
    [% комиссии](#formDealComission) первой созданной записи реестра
    % комиссии продаж.

*   Значение поля "% комиссии" для каждой отдельной сделки идет в расчет
    согласно значению crm_dict_dealStatus_end записи справочника
    [crm_dict_dealStatus](#dictionaryDealStatus):

    *   crm_dict_dealStatus_end=1 - % комиссии на момент сохранения этого
        статуса;

    *   остальные - % комиссии на конец
        [рассматриваемого периода](#crm16.filters).

*   При смене статуса сделки на запись справочника
    [crm_dict_dealStatus](#dictionaryDealStatus), у которой
    crm_dict_dealStatus_end=1, для нее сохраняется текущий % комиссии. Он
    будет использоваться в расчете, даже если строка динамической таблицы
    с таким % будет удалена.

*   Если в записи реестра % комиссии продаж
    указано несколько записей с одинаковыми датами начала, то в расчет идет
    последний % комиссии, удовлетворяющий требованиям.

*   Значение комиссии продаж в панели округляется до целого.

### Поток продаж {#crm16.pipeline}

*   Основная рабочая область содержит панели сделок, расположенные в виде
    таблицы, где:

    *   столбцы - статусы сделок (значения crm_dict_dealStatus_type записи
        справочника [crm_dict_dealStatus](#dictionaryDealStatus))
        согласно текущей [фильтрации](#crm16.filters)
    *   строки - сделки

*   Панели статусов окрашены в цвета, указанные в поле
    crm_dict_dealStatus_color записи справочника
    [crm_dict_dealStatus](#dictionaryDealStatus).

*   Панели сделок отсортированы в столбце согласно убыванию значений компонента
    [Бюджет](#formDeal) всех сделок текущего статуса.

*   Панель статуса содержит:
    *   Значение crm_dict_dealStatus_type записи справочника
        [crm_dict_dealStatus](#dictionaryDealStatus)
    *   Количество сделок данного статуса
    *   Сумма значений компонента
        [Бюджет](http://tdd.lan.arta.kz/docs/cases/crm/spec/html/sec.crm_conf_consist.html#crm2.formDeal)
        всех сделок текущего статуса.

*   Панель сделки содержит значение полей:
    *   [Наименование аккаунта](#formAccount)
    *   [Тема сотрудничества](#formDeal)
    *   [Бюджет](#formDeal)
    *   [Ответственный менеджер](#formDeal)

*   По нажатию на панель сделки откроется соответствующая запись реестра
    [Сделка](#registryDeal).

*   Цвет фона наименования аккаунта в панели - значение
    crm_dict_dealStatus_color записи справочника
    [crm_dict_dealStatus](#dictionaryDealStatus) выбранного статуса с 
    прозрачностью 30%.

*   Все поля в панелях сделки и статуса отображаются на одной строке без
    переносов.

*   Если значение поля в панели сделки или статуса такое, что не
    отображается в строке полностью, текст обрезается с добавлением
    многоточия.

*   Для полей в панелях сделки и статуса имеются тултипы.

*   Имеется возможность перемещения панелей сделок горизонтально между
    столбцами при помощи drag-n-drop.

*   Переместить панели сделки можно из всех столцов в любой столбец без
    исключений.

*   При перемещении панели сделки между стоблцами изменяется значение
    поля "Статус" данной записи реестра
    [Сделка](#registryDeal) согласно новому статусу (столбцу таблицы).

*   Ширина каждого столбца одинаково пропорциональна и в сумме составляет
    общую ширину основной рабочей области.

*   Минимальная ширина столбца - 200px.

*   Если таблица содержит один статус, то ее столбец отображается на
    ширину всей рабочей области.

*   Если количество столбцов такое, что они не отображаются в основной
    рабочей области полностью, отображается горизонтальный скролл.

*   Если количество панелей сделок такое, что не отображается в основной
    рабочей области полностью, отображается вертикальный скролл.

*   При прокрутке таблицы строка заголовков (статусов сделок) имеет
    фиксированное положение.

### Аналитика {#crm26.dashboard}

По нажатию на кнопку "Аналитика" в модуле "Управление продажами"
открывается [дашбоард Kibana](#dashboards_sales), который содержит 
следующие панели:

*   "Количество сделок по статусам" - таблица со столбцами:
    *   "Статус сделки" - значения crm_dict_dealStatus_type всех записей
        справочника [Статусы сделки](#dictionaryDealStatus) в единичном
        экземпляре (при наличии сделок с таким статусом);
    *   "Количество" - количество сделок соответствующего статуса;
    *   "Стоимость сделок" - суммарное значение полей "Бюджет"
        (crm_form_deal_main3_budget) всех сделок соответствующего статуса из
        текущей выборки.

*   "Среднее время прохождения сделками статусов" - таблица со столбцами:
    *   "Статус сделки" - значения crm_dict_dealStatus_type положительных
        записей (crm_dict_dealStatus_quality=1) справочника
        [Статусы сделки](#dictionaryDealStatus) в единичном экземпляре
        (при наличии сделок с таким статусом);
    *   "Длительность статуса (в днях)" - средняя продолжительность нахождения
        сделок в соответсвующем статусе.

*   "Количество просроченных сделок по статусам" - таблица со столбцами:
    *   "Статус сделки" - значения crm_dict_dealStatus_type неконечных
        записей (crm_dict_dealStatus_end=0) справочника
        [Статусы сделки](#dictionaryDealStatus) в единичном экземпляре
         (при наличии сделок с таким статусом);
    *   "Количество сделок, не сменивших статус своевременно" - количество
        сделок, не сменивших статус за длительность, указанную в документе по
        форме
        [Нормативы продолжительности статусов сделки](#formDealFlowStandard)
        для соответсвующего статуса;
    *   "Стоимость сделок" - суммарное значение полей "Бюджет"
        (crm_form_deal_main3_budget) сделок соответствующего статуса из текущей
        выборки.

*   "Количество сделок с отказом" - таблица со столбцами:
    *   "Этап отказа от сделки" - значения crm_dict_dealStatus_type положительных
        записей (crm_dict_dealStatus_quality=1) справочника
        [Статусы сделки](#dictionaryDealStatus) в единичном экземпляре
         (при наличии);
    *   "Количество отказов" - количество сделок, перешедших в негативный
        статус (crm_dict_dealStatus_quality=0 справочника
        [Статусы сделки](#dictionaryDealStatus)) с соответсвующего статуса;
    *   "Стоимость сделок" - суммарное значение полей "Бюджет"
        (crm_form_deal_main3_budget) сделок соответствующего статуса из текущей
        выборки.

*   "Факт продаж" - панели со значениями:
    *   "Факт продаж по стоимости" - суммарное значение полей "Бюджет"
        (crm_form_deal_main3_budget) сделок с положительным конечным статусом
        (crm_dict_dealStatus_end=1 справочника
        [Статусы сделки](#dictionaryDealStatus));
    *   "Факт продаж по количеству" - количество сделок с положительным конечным
        статусом (crm_dict_dealStatus_end=1 справочника
        [Статусы сделки](#dictionaryDealStatus)).

*   "План продаж" - панели со значениями:
    *   "План продаж по стоимости" - значение поля "Потенциальная стоимость (по
        умолчанию)" (crm_form_sales_cost_default_cost) документа по форме
        [План продаж](#formSalesCost);
    *   "План продаж по количеству" - значение поля "Потенциальное количество
        (по умолчанию)" (crm_form_sales_cost_default_value) документа по форме
        [План продаж](#formSalesCost).

*   "Топ прайс-листа" - таблица со столбцами:
    *   "Услуга/товар" - значение поля "Наименование товаров (работ, услуг)"
        (crm_form_deal_order_orderList) документа по форме
        [Счет-фактура](#formInvoice);
    *   "Количество (единиц)" - суммарное значение поля "Кол-во (объем)"
        (crm_form_deal_order_amount) документа по форме
        [Счет-фактура](#formInvoice).

        > **Примечание:**
        >
        > Значения в таблице сортируются в порядке убывания значений поля
        > "Кол-во (объем)" (crm_form_deal_order_amount).

*    "Список сделок" - таблица с полями:
    *   "Лид" - значащее содержимое записей реестра
        [Лид](#formLead);
    *   "Тема сотрудничества" - значение поля "Тема сотрудничества"
        (crm_form_deal_main2_theme) документа по форме
        [Сделка](#formDeal);
    *   "Статус" - значение поля "Статус" (crm_form_deal_main3_status)
        записей реестра
        [Сделка](#formDeal);
    *   "Ответственный менеджер" - зачение поля "Ответственный менеджер"
        (crm_form_deal_responsibleManager_responsible) документа по форме
        [Сделка](#formDeal);
    *   "Причина отказа" - значение поля "Причина отказа"
        (crm_form_deal_main3_rejection) документа по форме
        [Сделка](#formDeal);
    *   "Стоимость сделки" - значение поля "Бюджет"
        (crm_form_sales_cost_default_value) документа по форме
        [Сделка](#formDeal).

![Аналитика в модуле "Управление продажами"](resources/img/sales_dashboard.png)

### Продуктивность {#crm31.productivity}

По нажатию на кнопку "Продуктивность" в модуле "Управление продажами"
открывается [дашбоард Kibana](#dashboards_productivity), который содержит 
следующие панели:

*   "Отделения" - таблица со столбцами:

	*   "Отделение" - значение поля "Отделение" (`crm_form_deal_sales_pk1`) 
документа по форме [План продаж](#formSalesCost);

	*   "Средняя плановая стоимость продаж" - значение рассчитывается как:

		`сумма значений поля "Бюджет" сделок / количество сделок`

	При этом в расчет идут только сделки с положительным конечным 
статусом (crm_dict_dealStatus_end=1).

*   "Месяцы" - таблица со столбцами:

	*   "Месяц" - значение поля "Месяц" (`crm_form_deal_order_sales_month`) 
документа по форме [План продаж](#formSalesCost);

	*   "Средняя плановая стоимость продаж" - значение рассчитывается как:

		`сумма значений поля "Бюджет" сделок / количество сделок`

	При этом в расчет идут только сделки с положительным конечным 
статусом (`crm_dict_dealStatus_end=1`).

*   "Исполнение плана":

	*   "План продаж" - сумма значений всех полей "Стоимость продаж" 
(`crm_form_deal_main2_theme_pvalue_cN`) для всех "Отделений" 
(`crm_form_deal_sales_pk1`) всех документов по форме [План продаж](#formSalesCost).

	*   "Факт продаж" - сумма значений полей "Бюджет"
(`crm_form_deal_main3_budget`) всех сделок с положительным конечным 
статусом (`crm_dict_dealStatus_end=1`).

	*   "% исполнения плана продаж" - значение рассчитывается как:

		`"Факт продаж" / "План продаж" * 100%`

*   "Исполнение плана по темам сотрудничества" - таблица со столбцами:

	*   "Тема сотрудничества" - значение поля "Тема сотрудничества"
(`crm_form_deal_main2_theme_cN`) документа по форме [План продаж](#formSalesCost).

	*   "План продаж" - сумма значений полей "Стоимость продаж" 
(`crm_form_deal_main2_theme_pvalue_cN`) для всех "Отделений" 
(`crm_form_deal_sales_pk1`) соответствующей "Темы сотрудничества" 
(`crm_form_deal_main2_theme_cN`) всех документов по форме 
[План продаж](#formSalesCost).

	*   "Факт продаж" - сумма значений полей "Бюджет" 
(`crm_form_deal_main3_budget`) всех сделок с положительным конечным 
статусом (`crm_dict_dealStatus_end=1`), у которых в поле "Тема" 
(`crm_form_deal_main2_theme`) указана соответствующая "Тема 
сотрудничества".

*   "Исполнение плана по темам (гистрограмма)" - стобликовая диаграмма, в которой:

	*   ось X - значения полей "Тема сотрудничества"
(`crm_form_deal_main2_theme_cN`) документа по форме
[План продаж](#formSalesCost);

	*   ось Y - максимальное значение "План продаж" или "Факт продаж".

	Столбцы гистограммы - "План продаж" и "Факт продаж" согласно каждой 
"Теме сотрудничества" (crm_form_deal_main2_theme_cN).

![Продуктивность в модуле "Управление продажами"](resources/img/sales_productivity.png)


